/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.split.SplitSource;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ConnectorAwareSplitSource
implements SplitSource {
    private final ConnectorId connectorId;
    private final ConnectorTransactionHandle transactionHandle;
    private final ConnectorSplitSource source;

    public ConnectorAwareSplitSource(ConnectorId connectorId, ConnectorTransactionHandle transactionHandle, ConnectorSplitSource source) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        this.source = Objects.requireNonNull(source, "source is null");
    }

    @Override
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @Override
    public ConnectorTransactionHandle getTransactionHandle() {
        return this.transactionHandle;
    }

    @Override
    public ListenableFuture<List<Split>> getNextBatch(int maxSize) {
        ListenableFuture nextBatch = MoreFutures.toListenableFuture((CompletableFuture)this.source.getNextBatch(maxSize));
        return Futures.transform((ListenableFuture)nextBatch, splits -> Lists.transform((List)splits, split -> new Split(this.connectorId, this.transactionHandle, (ConnectorSplit)split)));
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }

    public String toString() {
        return this.connectorId + ":" + this.source;
    }
}

