/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.memory.LocalMemoryContext;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spiller.FileSingleStreamSpiller;
import com.facebook.presto.spiller.SingleStreamSpiller;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class FileSingleStreamSpillerFactory
implements SingleStreamSpillerFactory {
    private static final Logger log = Logger.get(FileSingleStreamSpillerFactory.class);
    @VisibleForTesting
    static final String SPILL_FILE_PREFIX = "spill";
    @VisibleForTesting
    static final String SPILL_FILE_SUFFIX = ".bin";
    private static final String SPILL_FILE_GLOB = "spill*.bin";
    private final ListeningExecutorService executor;
    private final PagesSerdeFactory serdeFactory;
    private final List<Path> spillPaths;
    private final SpillerStats spillerStats;
    private final double maxUsedSpaceThreshold;
    private int roundRobinIndex;

    @Inject
    public FileSingleStreamSpillerFactory(BlockEncodingSerde blockEncodingSerde, SpillerStats spillerStats, FeaturesConfig featuresConfig) {
        this(MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(Objects.requireNonNull(featuresConfig, "featuresConfig is null").getSpillerThreads(), Threads.daemonThreadsNamed((String)"binary-spiller-%s"))), blockEncodingSerde, spillerStats, Objects.requireNonNull(featuresConfig, "featuresConfig is null").getSpillerSpillPaths(), Objects.requireNonNull(featuresConfig, "featuresConfig is null").getSpillMaxUsedSpaceThreshold());
    }

    @VisibleForTesting
    public FileSingleStreamSpillerFactory(ListeningExecutorService executor, BlockEncodingSerde blockEncodingSerde, SpillerStats spillerStats, List<Path> spillPaths, double maxUsedSpaceThreshold) {
        this.serdeFactory = new PagesSerdeFactory(Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null"), false);
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.spillerStats = Objects.requireNonNull(spillerStats, "spillerStats can not be null");
        Objects.requireNonNull(spillPaths, "spillPaths is null");
        this.spillPaths = ImmutableList.copyOf(spillPaths);
        spillPaths.forEach(path -> {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("could not create spill path %s; adjust experimental.spiller-spill-path config property or filesystem permissions", path), e);
            }
            if (!path.toFile().canWrite()) {
                throw new IllegalArgumentException(String.format("spill path %s is not writable; adjust experimental.spiller-spill-path config property or filesystem permissions", path));
            }
        });
        this.maxUsedSpaceThreshold = maxUsedSpaceThreshold;
        this.roundRobinIndex = 0;
    }

    @PostConstruct
    public void cleanupOldSpillFiles() {
        this.spillPaths.forEach(FileSingleStreamSpillerFactory::cleanupOldSpillFiles);
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdownNow();
    }

    private static void cleanupOldSpillFiles(Path path) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, SPILL_FILE_GLOB);){
            stream.forEach(spillFile -> {
                try {
                    log.info("Deleting old spill file: " + spillFile);
                    Files.delete(spillFile);
                }
                catch (Exception e) {
                    log.warn("Could not cleanup old spill file: " + spillFile);
                }
            });
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Error cleaning spill files");
        }
    }

    @Override
    public SingleStreamSpiller create(List<Type> types, SpillContext spillContext, LocalMemoryContext memoryContext) {
        return new FileSingleStreamSpiller(this.serdeFactory.createPagesSerde(), this.executor, this.getNextSpillPath(), this.spillerStats, spillContext, memoryContext);
    }

    private synchronized Path getNextSpillPath() {
        int spillPathsCount = this.spillPaths.size();
        for (int i = 0; i < spillPathsCount; ++i) {
            int pathIndex = (this.roundRobinIndex + i) % spillPathsCount;
            Path path = this.spillPaths.get(pathIndex);
            if (!this.hasEnoughDiskSpace(path)) continue;
            this.roundRobinIndex = (this.roundRobinIndex + i + 1) % spillPathsCount;
            return path;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.OUT_OF_SPILL_SPACE, "No free space available for spill");
    }

    private boolean hasEnoughDiskSpace(Path path) {
        try {
            FileStore fileStore = Files.getFileStore(path);
            return (double)fileStore.getUsableSpace() > (double)fileStore.getTotalSpace() * (1.0 - this.maxUsedSpaceThreshold);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.OUT_OF_SPILL_SPACE, "Cannot determine free space for spill", (Throwable)e);
        }
    }
}

