/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class LdapConfig {
    private String ldapUrl;
    private String userBindSearchPattern;
    private String groupAuthorizationSearchPattern;
    private String userBaseDistinguishedName;
    private Duration ldapCacheTtl = new Duration(1.0, TimeUnit.HOURS);

    @NotNull
    @Pattern(regexp="^ldaps://.*", message="LDAP without SSL/TLS unsupported. Expected ldaps://")
    public String getLdapUrl() {
        return this.ldapUrl;
    }

    @Config(value="authentication.ldap.url")
    @ConfigDescription(value="URL of the LDAP server")
    public LdapConfig setLdapUrl(String url) {
        this.ldapUrl = url;
        return this;
    }

    @NotNull
    public String getUserBindSearchPattern() {
        return this.userBindSearchPattern;
    }

    @Config(value="authentication.ldap.user-bind-pattern")
    @ConfigDescription(value="Custom user bind pattern. Example: ${USER}@example.com")
    public LdapConfig setUserBindSearchPattern(String userBindSearchPattern) {
        this.userBindSearchPattern = userBindSearchPattern;
        return this;
    }

    public String getGroupAuthorizationSearchPattern() {
        return this.groupAuthorizationSearchPattern;
    }

    @Config(value="authentication.ldap.group-auth-pattern")
    @ConfigDescription(value="Custom group authorization check query. Example: &(objectClass=user)(memberOf=cn=group)(user=username)")
    public LdapConfig setGroupAuthorizationSearchPattern(String groupAuthorizationSearchPattern) {
        this.groupAuthorizationSearchPattern = groupAuthorizationSearchPattern;
        return this;
    }

    public String getUserBaseDistinguishedName() {
        return this.userBaseDistinguishedName;
    }

    @Config(value="authentication.ldap.user-base-dn")
    @ConfigDescription(value="Base distinguished name of the user. Example: dc=example,dc=com")
    public LdapConfig setUserBaseDistinguishedName(String userBaseDistinguishedName) {
        this.userBaseDistinguishedName = userBaseDistinguishedName;
        return this;
    }

    @NotNull
    public Duration getLdapCacheTtl() {
        return this.ldapCacheTtl;
    }

    @Config(value="authentication.ldap.cache-ttl")
    public LdapConfig setLdapCacheTtl(Duration ldapCacheTtl) {
        this.ldapCacheTtl = ldapCacheTtl;
        return this;
    }
}

