/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.server.NodeStatus;
import com.facebook.presto.server.ServerConfig;
import com.sun.management.OperatingSystemMXBean;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/v1/status")
public class StatusResource {
    private final NodeInfo nodeInfo;
    private final NodeVersion version;
    private final String environment;
    private final boolean coordinator;
    private final long startTime = System.nanoTime();
    private final int logicalCores;
    private final LocalMemoryManager memoryManager;
    private final MemoryMXBean memoryMXBean;
    private OperatingSystemMXBean operatingSystemMXBean;

    @Inject
    public StatusResource(NodeVersion nodeVersion, NodeInfo nodeInfo, ServerConfig serverConfig, LocalMemoryManager memoryManager) {
        this.nodeInfo = Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.version = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.environment = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment();
        this.coordinator = Objects.requireNonNull(serverConfig, "serverConfig is null").isCoordinator();
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.logicalCores = Runtime.getRuntime().availableProcessors();
        if (ManagementFactory.getOperatingSystemMXBean() instanceof OperatingSystemMXBean) {
            this.operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        }
    }

    @GET
    @Produces(value={"application/json"})
    public NodeStatus getStatus() {
        return new NodeStatus(this.nodeInfo.getNodeId(), this.version, this.environment, this.coordinator, Duration.nanosSince((long)this.startTime), this.nodeInfo.getInternalAddress(), this.nodeInfo.getExternalAddress(), this.memoryManager.getInfo(), this.logicalCores, this.operatingSystemMXBean == null ? 0.0 : this.operatingSystemMXBean.getProcessCpuLoad(), this.operatingSystemMXBean == null ? 0.0 : this.operatingSystemMXBean.getSystemCpuLoad(), this.memoryMXBean.getHeapMemoryUsage().getUsed(), this.memoryMXBean.getHeapMemoryUsage().getMax(), this.memoryMXBean.getNonHeapMemoryUsage().getUsed());
    }
}

