/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/v1/queryState")
public class QueryStateInfoResource {
    private final QueryManager queryManager;
    private final ResourceGroupManager resourceGroupManager;

    @Inject
    public QueryStateInfoResource(QueryManager queryManager, ResourceGroupManager resourceGroupManager) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
    }

    @GET
    @Produces(value={"application/json"})
    public List<QueryStateInfo> getQueryStateInfos(@QueryParam(value="user") String user) {
        List queryInfos = this.queryManager.getAllQueryInfo();
        if (!Strings.isNullOrEmpty((String)user)) {
            queryInfos = (List)queryInfos.stream().filter(queryInfo -> Pattern.matches(user, queryInfo.getSession().getUser())).collect(ImmutableList.toImmutableList());
        }
        queryInfos = (List)queryInfos.stream().filter(queryInfo -> !queryInfo.getState().isDone()).collect(ImmutableList.toImmutableList());
        Map rootResourceGroupInfos = (Map)queryInfos.stream().map(queryInfo -> this.queryManager.getQueryResourceGroup(queryInfo.getQueryId())).filter(Optional::isPresent).map(Optional::get).map(ResourceGroupId::getRoot).distinct().collect(ImmutableMap.toImmutableMap(Function.identity(), this.resourceGroupManager::getResourceGroupInfo));
        return (List)queryInfos.stream().map(queryInfo -> QueryStateInfo.createQueryStateInfo(queryInfo, this.queryManager.getQueryResourceGroup(queryInfo.getQueryId()), this.queryManager.getQueryResourceGroup(queryInfo.getQueryId()).map(ResourceGroupId::getRoot).map(rootResourceGroupInfos::get))).collect(ImmutableList.toImmutableList());
    }

    @GET
    @Path(value="{queryId}")
    @Produces(value={"application/json"})
    public QueryStateInfo getQueryStateInfo(@PathParam(value="queryId") String queryId) throws WebApplicationException {
        try {
            QueryInfo queryInfo = this.queryManager.getQueryInfo(new QueryId(queryId));
            Optional<ResourceGroupId> resourceGroup = this.queryManager.getQueryResourceGroup(queryInfo.getQueryId());
            return QueryStateInfo.createQueryStateInfo(queryInfo, resourceGroup, resourceGroup.map(ResourceGroupId::getRoot).map(this.resourceGroupManager::getResourceGroupInfo));
        }
        catch (NoSuchElementException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }
}

