/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.security.CatalogAccessControlRule;
import com.facebook.presto.security.FileBasedSystemAccessControlRules;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.SystemAccessControl;
import com.facebook.presto.spi.security.SystemAccessControlFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class FileBasedSystemAccessControl
implements SystemAccessControl {
    public static final String NAME = "file";
    private final List<CatalogAccessControlRule> catalogRules;

    private FileBasedSystemAccessControl(List<CatalogAccessControlRule> catalogRules) {
        this.catalogRules = catalogRules;
    }

    public void checkCanSetUser(Principal principal, String userName) {
    }

    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
    }

    public void checkCanAccessCatalog(Identity identity, String catalogName) {
        if (!this.canAccessCatalog(identity, catalogName)) {
            AccessDeniedException.denyCatalogAccess((String)catalogName);
        }
    }

    public Set<String> filterCatalogs(Identity identity, Set<String> catalogs) {
        ImmutableSet.Builder filteredCatalogs = ImmutableSet.builder();
        for (String catalog : catalogs) {
            if (!this.canAccessCatalog(identity, catalog)) continue;
            filteredCatalogs.add((Object)catalog);
        }
        return filteredCatalogs.build();
    }

    private boolean canAccessCatalog(Identity identity, String catalogName) {
        for (CatalogAccessControlRule rule : this.catalogRules) {
            Optional<Boolean> allowed = rule.match(identity.getUser(), catalogName);
            if (!allowed.isPresent()) continue;
            return allowed.get();
        }
        return false;
    }

    public void checkCanCreateSchema(Identity identity, CatalogSchemaName schema) {
    }

    public void checkCanDropSchema(Identity identity, CatalogSchemaName schema) {
    }

    public void checkCanRenameSchema(Identity identity, CatalogSchemaName schema, String newSchemaName) {
    }

    public void checkCanShowSchemas(Identity identity, String catalogName) {
    }

    public Set<String> filterSchemas(Identity identity, String catalogName, Set<String> schemaNames) {
        if (!this.canAccessCatalog(identity, catalogName)) {
            return ImmutableSet.of();
        }
        return schemaNames;
    }

    public void checkCanCreateTable(Identity identity, CatalogSchemaTableName table) {
    }

    public void checkCanDropTable(Identity identity, CatalogSchemaTableName table) {
    }

    public void checkCanRenameTable(Identity identity, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
    }

    public void checkCanShowTablesMetadata(Identity identity, CatalogSchemaName schema) {
    }

    public Set<SchemaTableName> filterTables(Identity identity, String catalogName, Set<SchemaTableName> tableNames) {
        if (!this.canAccessCatalog(identity, catalogName)) {
            return ImmutableSet.of();
        }
        return tableNames;
    }

    public void checkCanAddColumn(Identity identity, CatalogSchemaTableName table) {
    }

    public void checkCanDropColumn(Identity identity, CatalogSchemaTableName table) {
    }

    public void checkCanRenameColumn(Identity identity, CatalogSchemaTableName table) {
    }

    public void checkCanSelectFromTable(Identity identity, CatalogSchemaTableName table) {
    }

    public void checkCanInsertIntoTable(Identity identity, CatalogSchemaTableName table) {
    }

    public void checkCanDeleteFromTable(Identity identity, CatalogSchemaTableName table) {
    }

    public void checkCanCreateView(Identity identity, CatalogSchemaTableName view) {
    }

    public void checkCanDropView(Identity identity, CatalogSchemaTableName view) {
    }

    public void checkCanSelectFromView(Identity identity, CatalogSchemaTableName view) {
    }

    public void checkCanCreateViewWithSelectFromTable(Identity identity, CatalogSchemaTableName table) {
    }

    public void checkCanCreateViewWithSelectFromView(Identity identity, CatalogSchemaTableName view) {
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, String catalogName, String propertyName) {
    }

    public void checkCanGrantTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table, String grantee, boolean withGrantOption) {
    }

    public void checkCanRevokeTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table, String revokee, boolean grantOptionFor) {
    }

    public static class Factory
    implements SystemAccessControlFactory {
        private static final String CONFIG_FILE_NAME = "security.config-file";

        public String getName() {
            return FileBasedSystemAccessControl.NAME;
        }

        public SystemAccessControl create(Map<String, String> config) {
            Objects.requireNonNull(config, "config is null");
            String configFileName = config.get(CONFIG_FILE_NAME);
            Preconditions.checkState((configFileName != null ? 1 : 0) != 0, (String)"Security configuration must contain the '%s' property", (Object)CONFIG_FILE_NAME);
            try {
                Path path = Paths.get(configFileName, new String[0]);
                if (!path.isAbsolute()) {
                    path = path.toAbsolutePath();
                }
                path.toFile().canRead();
                ImmutableList.Builder catalogRulesBuilder = ImmutableList.builder();
                catalogRulesBuilder.addAll(((FileBasedSystemAccessControlRules)JsonCodec.jsonCodec(FileBasedSystemAccessControlRules.class).fromJson(Files.readAllBytes(path))).getCatalogRules());
                catalogRulesBuilder.add((Object)new CatalogAccessControlRule(true, Optional.of(Pattern.compile(".*")), Optional.of(Pattern.compile("system"))));
                return new FileBasedSystemAccessControl((List)catalogRulesBuilder.build());
            }
            catch (IOException | SecurityException | InvalidPathException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

