/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.VariableInstruction;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.MapTransformKeyFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.sql.gen.lambda.BinaryFunctionInterface;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class MapTransformValueFunction
extends SqlScalarFunction {
    public static final MapTransformValueFunction MAP_TRANSFORM_VALUE_FUNCTION = new MapTransformValueFunction();
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(MapTransformKeyFunction.class, "createState", MapType.class);

    private MapTransformValueFunction() {
        super(new Signature("transform_values", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K"), (Object)Signature.typeVariable("V1"), (Object)Signature.typeVariable("V2")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,V2)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K,V1)"), (Object)TypeSignature.parseTypeSignature((String)"function(K,V1,V2)")), false));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public String getDescription() {
        return "apply lambda to each entry of the map and transform the value";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V1");
        Type transformedValueType = boundVariables.getTypeVariable("V2");
        Type resultMapType = typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)transformedValueType.getTypeSignature())));
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), (List<Boolean>)ImmutableList.of((Object)false, (Object)false), (List<Optional<Class>>)ImmutableList.of(Optional.empty(), Optional.of(BinaryFunctionInterface.class)), MapTransformValueFunction.generateTransform(keyType, valueType, transformedValueType, resultMapType), Optional.of(STATE_FACTORY.bindTo(resultMapType)), this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static Object createState(MapType mapType) {
        return new PageBuilder((List)ImmutableList.of((Object)mapType));
    }

    private static MethodHandle generateTransform(Type keyType, Type valueType, Type transformedValueType, Type resultMapType) {
        CallSiteBinder binder = new CallSiteBinder();
        Class keyJavaType = Primitives.wrap((Class)keyType.getJavaType());
        Class valueJavaType = Primitives.wrap((Class)valueType.getJavaType());
        Class transformedValueJavaType = Primitives.wrap((Class)transformedValueType.getJavaType());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)"MapTransformValue"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        Parameter state = Parameter.arg((String)"state", Object.class);
        Parameter block = Parameter.arg((String)"block", Block.class);
        Parameter function = Parameter.arg((String)"function", BinaryFunctionInterface.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "transform", ParameterizedType.type(Block.class), (Iterable)ImmutableList.of((Object)state, (Object)block, (Object)function));
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable positionCount = scope.declareVariable(Integer.TYPE, "positionCount");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable pageBuilder = scope.declareVariable(PageBuilder.class, "pageBuilder");
        Variable mapBlockBuilder = scope.declareVariable(BlockBuilder.class, "mapBlockBuilder");
        Variable blockBuilder = scope.declareVariable(BlockBuilder.class, "blockBuilder");
        Variable keyElement = scope.declareVariable(keyJavaType, "keyElement");
        Variable valueElement = scope.declareVariable(valueJavaType, "valueElement");
        Variable transformedValueElement = scope.declareVariable(transformedValueJavaType, "transformedValueElement");
        body.append((BytecodeNode)positionCount.set(block.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0])));
        body.append((BytecodeNode)pageBuilder.set(state.cast(PageBuilder.class)));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)pageBuilder.invoke("isFull", Boolean.TYPE, new BytecodeExpression[0])).ifTrue((BytecodeNode)pageBuilder.invoke("reset", Void.TYPE, new BytecodeExpression[0])));
        body.append((BytecodeNode)mapBlockBuilder.set(pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)0)})));
        body.append((BytecodeNode)blockBuilder.set(mapBlockBuilder.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
        BytecodeBlock throwNullKeyException = new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.newInstance(PrestoException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.getStatic((Class)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.getDeclaringClass(), (String)"INVALID_FUNCTION_ARGUMENT").cast(ErrorCodeSupplier.class), BytecodeExpressions.constantString((String)"map key cannot be null")})).throwObject();
        SqlTypeBytecodeExpression keySqlType = SqlTypeBytecodeExpression.constantType(binder, keyType);
        BytecodeBlock loadKeyElement = !keyType.equals((Object)UnknownType.UNKNOWN) ? new BytecodeBlock().append((BytecodeNode)keyElement.set(keySqlType.getValue((BytecodeExpression)block, (BytecodeExpression)position).cast(keyJavaType))) : new BytecodeBlock().append((BytecodeNode)mapBlockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop()).append((BytecodeNode)keyElement.set(BytecodeExpressions.constantNull((Class)keyJavaType))).append((BytecodeNode)throwNullKeyException);
        SqlTypeBytecodeExpression valueSqlType = SqlTypeBytecodeExpression.constantType(binder, valueType);
        Object loadValueElement = !valueType.equals((Object)UnknownType.UNKNOWN) ? new IfStatement().condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1))})).ifTrue((BytecodeNode)valueElement.set(BytecodeExpressions.constantNull((Class)valueJavaType))).ifFalse((BytecodeNode)valueElement.set(valueSqlType.getValue((BytecodeExpression)block, BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1))).cast(valueJavaType))) : new BytecodeBlock().append((BytecodeNode)valueElement.set(BytecodeExpressions.constantNull((Class)valueJavaType)));
        Object writeTransformedValueElement = !transformedValueType.equals((Object)UnknownType.UNKNOWN) ? new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)transformedValueElement, (BytecodeExpression)BytecodeExpressions.constantNull((Class)transformedValueJavaType))).ifTrue((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, transformedValueType).writeValue((BytecodeExpression)blockBuilder, transformedValueElement.cast(transformedValueType.getJavaType()))) : new BytecodeBlock().append((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop());
        body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)positionCount)).update((BytecodeNode)VariableInstruction.incrementVariable((Variable)position, (byte)2)).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)loadKeyElement).append((BytecodeNode)loadValueElement).append((BytecodeNode)transformedValueElement.set(function.invoke("apply", Object.class, new BytecodeExpression[]{keyElement.cast(Object.class), valueElement.cast(Object.class)}).cast(transformedValueJavaType))).append((BytecodeNode)keySqlType.invoke("appendTo", Void.TYPE, new BytecodeExpression[]{block, position, blockBuilder})).append((BytecodeNode)writeTransformedValueElement)));
        body.append((BytecodeNode)mapBlockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop());
        body.append((BytecodeNode)pageBuilder.invoke("declarePosition", Void.TYPE, new BytecodeExpression[0]));
        body.append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, resultMapType).invoke("getObject", Object.class, new BytecodeExpression[]{mapBlockBuilder.cast(Block.class), BytecodeExpressions.subtract((BytecodeExpression)mapBlockBuilder.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]), (BytecodeExpression)BytecodeExpressions.constantInt((int)1))}).ret());
        Class generatedClass = CompilerUtils.defineClass((ClassDefinition)definition, Object.class, binder.getBindings(), (ClassLoader)MapTransformValueFunction.class.getClassLoader());
        return Reflection.methodHandle(generatedClass, "transform", Object.class, Block.class, BinaryFunctionInterface.class);
    }
}

