/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameters;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;

@ScalarOperator(value=OperatorType.CAST)
public final class MapToMapCast {
    private MapToMapCast() {
    }

    @TypeParameters(value={@TypeParameter(value="FK"), @TypeParameter(value="FV"), @TypeParameter(value="TK"), @TypeParameter(value="TV")})
    @SqlType(value="map(TK,TV)")
    public static Block toMap(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"TK", "TK"}) MethodHandle toKeyEqualsFunction, @OperatorDependency(operator=OperatorType.CAST, returnType="TK", argumentTypes={"FK"}) MethodHandle keyCastFunction, @OperatorDependency(operator=OperatorType.CAST, returnType="TV", argumentTypes={"FV"}) MethodHandle valueCastFunction, @TypeParameter(value="FK") Type fromKeyType, @TypeParameter(value="FV") Type fromValueType, @TypeParameter(value="TK") Type toKeyType, @TypeParameter(value="TV") Type toValueType, @TypeParameter(value="map(TK,TV)") Type toMapType, ConnectorSession session, @SqlType(value="map(FK,FV)") Block fromMap) {
        int i;
        Class<?>[] parameterTypes = keyCastFunction.type().parameterArray();
        for (i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != ConnectorSession.class) continue;
            keyCastFunction = MethodHandles.insertArguments(keyCastFunction, i, session);
            break;
        }
        parameterTypes = valueCastFunction.type().parameterArray();
        for (i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != ConnectorSession.class) continue;
            valueCastFunction = MethodHandles.insertArguments(valueCastFunction, i, session);
            break;
        }
        TypedSet typedSet = new TypedSet(toKeyType, fromMap.getPositionCount() / 2, "map-to-map cast");
        BlockBuilder keyBlockBuilder = toKeyType.createBlockBuilder(new BlockBuilderStatus(), fromMap.getPositionCount() / 2);
        for (int i2 = 0; i2 < fromMap.getPositionCount(); i2 += 2) {
            Object fromKey = TypeUtils.readNativeValue((Type)fromKeyType, (Block)fromMap, (int)i2);
            try {
                Object toKey = keyCastFunction.invoke(fromKey);
                if (toKey == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
                }
                TypeUtils.writeNativeValue((Type)toKeyType, (BlockBuilder)keyBlockBuilder, (Object)toKey);
                continue;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        Block keyBlock = keyBlockBuilder.build();
        BlockBuilder mapBlockBuilder = toMapType.createBlockBuilder(new BlockBuilderStatus(), 1);
        BlockBuilder blockBuilder = mapBlockBuilder.beginBlockEntry();
        for (int i3 = 0; i3 < fromMap.getPositionCount(); i3 += 2) {
            if (!typedSet.contains(keyBlock, i3 / 2)) {
                typedSet.add(keyBlock, i3 / 2);
                toKeyType.appendTo(keyBlock, i3 / 2, blockBuilder);
                if (fromMap.isNull(i3 + 1)) {
                    blockBuilder.appendNull();
                    continue;
                }
                Object fromValue = TypeUtils.readNativeValue((Type)fromValueType, (Block)fromMap, (int)(i3 + 1));
                try {
                    Object toValue = valueCastFunction.invoke(fromValue);
                    TypeUtils.writeNativeValue((Type)toValueType, (BlockBuilder)blockBuilder, (Object)toValue);
                    continue;
                }
                catch (Throwable t) {
                    throw Failures.internalError(t);
                }
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "duplicate keys");
        }
        mapBlockBuilder.closeEntry();
        return (Block)toMapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }
}

