/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class MapConstructor
extends SqlScalarFunction {
    public static final MapConstructor MAP_CONSTRUCTOR = new MapConstructor();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapConstructor.class, "createMap", MapType.class, MethodHandle.class, MethodHandle.class, State.class, Block.class, Block.class);
    private static final String DESCRIPTION = "Constructs a map from the given key/value arrays";

    public MapConstructor() {
        super(new Signature("map", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,V)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(K)"), (Object)TypeSignature.parseTypeSignature((String)"array(V)")), false));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        Type mapType = typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
        MethodHandle keyHashCode = functionRegistry.getScalarFunctionImplementation(functionRegistry.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)keyType))).getMethodHandle();
        MethodHandle keyEqual = functionRegistry.getScalarFunctionImplementation(functionRegistry.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)keyType, (Object)keyType))).getMethodHandle();
        MethodHandle instanceFactory = Reflection.constructorMethodHandle(State.class, MapType.class).bindTo(mapType);
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), (List<Boolean>)ImmutableList.of((Object)false, (Object)false), (List<Optional<Class>>)ImmutableList.of(Optional.empty(), Optional.empty()), METHOD_HANDLE.bindTo(mapType).bindTo(keyEqual).bindTo(keyHashCode), Optional.of(instanceFactory), this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static Block createMap(MapType mapType, MethodHandle keyEqual, MethodHandle keyHashCode, State state, Block keyBlock, Block valueBlock) {
        Failures.checkCondition(keyBlock.getPositionCount() == valueBlock.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key and value arrays must be the same length", new Object[0]);
        PageBuilder pageBuilder = state.getPageBuilder();
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        BlockBuilder mapBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder blockBuilder = mapBlockBuilder.beginBlockEntry();
        for (int i = 0; i < keyBlock.getPositionCount(); ++i) {
            if (keyBlock.isNull(i)) {
                mapBlockBuilder.closeEntry();
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
            }
            mapType.getKeyType().appendTo(keyBlock, i, blockBuilder);
            mapType.getValueType().appendTo(valueBlock, i, blockBuilder);
        }
        mapBlockBuilder.closeEntry();
        pageBuilder.declarePosition();
        return mapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }

    public static final class State {
        private final PageBuilder pageBuilder;

        public State(MapType mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        public PageBuilder getPageBuilder() {
            return this.pageBuilder;
        }
    }
}

