/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ListLiteralCast {
    private ListLiteralCast() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="ListLiteral")
    public static List<Integer> castArrayToListLiteral(@SqlType(value="array(integer)") Block array) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (int i = 0; i < array.getPositionCount(); ++i) {
            listBuilder.add((Object)array.getInt(i, 0));
        }
        return listBuilder.build();
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="ListLiteral")
    public static List<List<Integer>> castArrayOfArraysToListLiteral(@SqlType(value="array(array(integer))") Block arrayOfArrays) {
        ArrayType arrayType = new ArrayType((Type)IntegerType.INTEGER);
        ImmutableList.Builder outerListBuilder = ImmutableList.builder();
        for (int i = 0; i < arrayOfArrays.getPositionCount(); ++i) {
            Block subArray = arrayType.getObject(arrayOfArrays, i);
            outerListBuilder.add(ListLiteralCast.castArrayToListLiteral(subArray));
        }
        return outerListBuilder.build();
    }
}

