/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.SingleRowBlockWriter;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.JsonCastException;
import com.facebook.presto.util.JsonUtil;
import com.facebook.presto.util.Reflection;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JsonToRowCast
extends SqlOperator {
    public static final JsonToRowCast JSON_TO_ROW = new JsonToRowCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonToRowCast.class, "toRow", RowType.class, JsonUtil.BlockBuilderAppender[].class, Optional.class, ConnectorSession.class, Slice.class);

    private JsonToRowCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.withVariadicBound("T", "row")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"json")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        RowType rowType = (RowType)boundVariables.getTypeVariable("T");
        Failures.checkCondition(JsonUtil.canCastFromJson((Type)rowType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast JSON to %s", rowType);
        List rowFields = rowType.getFields();
        JsonUtil.BlockBuilderAppender[] fieldAppenders = (JsonUtil.BlockBuilderAppender[])rowFields.stream().map(rowField -> JsonUtil.BlockBuilderAppender.createBlockBuilderAppender(rowField.getType())).toArray(JsonUtil.BlockBuilderAppender[]::new);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(rowType).bindTo(fieldAppenders).bindTo(JsonUtil.getFieldNameToIndex(rowFields));
        return new ScalarFunctionImplementation(true, (List<Boolean>)ImmutableList.of((Object)false), methodHandle, this.isDeterministic());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UsedByGeneratedCode
    public static Block toRow(RowType rowType, JsonUtil.BlockBuilderAppender[] fieldAppenders, Optional<Map<String, Integer>> fieldNameToIndex, ConnectorSession connectorSession, Slice json) {
        try (JsonParser jsonParser = JsonUtil.createJsonParser(JsonUtil.JSON_FACTORY, json);){
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                Block block = null;
                return block;
            }
            if (jsonParser.getCurrentToken() != JsonToken.START_ARRAY && jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new JsonCastException(String.format("Expected a json array or object, but got %s", jsonParser.getText()));
            }
            BlockBuilder rowBlockBuilder = rowType.createBlockBuilder(new BlockBuilderStatus(), 1);
            JsonUtil.parseJsonToSingleRowBlock(jsonParser, (SingleRowBlockWriter)rowBlockBuilder.beginBlockEntry(), fieldAppenders, fieldNameToIndex);
            rowBlockBuilder.closeEntry();
            if (jsonParser.nextToken() != null) {
                throw new JsonCastException(String.format("Unexpected trailing token: %s", jsonParser.getText()));
            }
            Block block = rowType.getObject((Block)rowBlockBuilder, 0);
            return block;
        }
        catch (PrestoException | JsonCastException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s. %s\n%s", rowType, e.getMessage(), JsonUtil.truncateIfNecessaryForErrorMessage(json)), e);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s.\n%s", rowType, JsonUtil.truncateIfNecessaryForErrorMessage(json)), (Throwable)e);
        }
    }
}

