/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import java.util.List;

public final class GroupingOperationFunction {
    public static final String BIGINT_GROUPING = "bigint_grouping";
    public static final String INTEGER_GROUPING = "integer_grouping";
    public static final int MAX_NUMBER_GROUPING_ARGUMENTS_BIGINT = 63;
    public static final int MAX_NUMBER_GROUPING_ARGUMENTS_INTEGER = 31;

    private GroupingOperationFunction() {
    }

    @ScalarFunction(value="integer_grouping", deterministic=false)
    @SqlType(value="integer")
    public static long integerGrouping(@SqlType(value="bigint") long groupId, @SqlType(value="ListLiteral") List<Integer> columns, @SqlType(value="ListLiteral") List<List<Integer>> groupingSetDescriptors) {
        return GroupingOperationFunction.calculateGrouping(groupId, columns, groupingSetDescriptors);
    }

    @ScalarFunction(value="bigint_grouping", deterministic=false)
    @SqlType(value="bigint")
    public static long bigintGrouping(@SqlType(value="bigint") long groupId, @SqlType(value="ListLiteral") List<Integer> columns, @SqlType(value="ListLiteral") List<List<Integer>> groupingSetDescriptors) {
        return GroupingOperationFunction.calculateGrouping(groupId, columns, groupingSetDescriptors);
    }

    private static long calculateGrouping(long groupId, List<Integer> columns, List<List<Integer>> groupingSetDescriptors) {
        long grouping = (1L << columns.size()) - 1L;
        List<Integer> groupingSet = groupingSetDescriptors.get((int)groupId);
        for (Integer groupingColumn : groupingSet) {
            int index = columns.indexOf(groupingColumn);
            if (index == -1) continue;
            grouping &= 1L << columns.size() - 1 - index ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return grouping;
    }
}

