/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.AbstractType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;

@ScalarFunction(value="arrays_overlap")
@Description(value="Returns true if arrays have common elements")
public final class ArraysOverlapFunction {
    private int[] leftPositions;
    private int[] rightPositions;
    private long[] leftLongArray;
    private long[] rightLongArray;

    @TypeParameter(value="E")
    public ArraysOverlapFunction(@TypeParameter(value="E") Type elementType) {
    }

    public ArraysOverlapFunction() {
    }

    private static IntComparator intBlockCompare(final Type type, final Block block) {
        return new AbstractIntComparator(){

            public int compare(int left, int right) {
                if (block.isNull(left) && block.isNull(right)) {
                    return 0;
                }
                if (block.isNull(left)) {
                    return 1;
                }
                if (block.isNull(right)) {
                    return -1;
                }
                return type.compareTo(block, left, block, right);
            }
        };
    }

    @SqlNullable
    @SqlType(value="boolean")
    public Boolean arraysOverlapInt(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"integer", "integer"}) MethodHandle lessThanFunction, @SqlType(value="array(integer)") Block leftArray, @SqlType(value="array(integer)") Block rightArray) {
        return this.genericArraysOverlap(leftArray, rightArray, (AbstractType)IntegerType.INTEGER);
    }

    @SqlNullable
    @SqlType(value="boolean")
    public Boolean arraysOverlapBigInt(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"bigint", "bigint"}) MethodHandle lessThanFunction, @SqlType(value="array(bigint)") Block leftArray, @SqlType(value="array(bigint)") Block rightArray) {
        return this.genericArraysOverlap(leftArray, rightArray, (AbstractType)BigintType.BIGINT);
    }

    @SqlNullable
    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public Boolean arraysOverlap(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle lessThanFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int i;
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (leftPositionCount == 0 || rightPositionCount == 0) {
            return false;
        }
        if (this.leftPositions == null || this.leftPositions.length < leftPositionCount) {
            this.leftPositions = new int[leftPositionCount * 2];
        }
        if (this.rightPositions == null || this.rightPositions.length < rightPositionCount) {
            this.rightPositions = new int[rightPositionCount * 2];
        }
        for (i = 0; i < leftPositionCount; ++i) {
            this.leftPositions[i] = i;
        }
        for (i = 0; i < rightPositionCount; ++i) {
            this.rightPositions[i] = i;
        }
        IntArrays.quickSort((int[])this.leftPositions, (int)0, (int)leftPositionCount, (IntComparator)ArraysOverlapFunction.intBlockCompare(type, leftArray));
        IntArrays.quickSort((int[])this.rightPositions, (int)0, (int)rightPositionCount, (IntComparator)ArraysOverlapFunction.intBlockCompare(type, rightArray));
        int leftCurrentPosition = 0;
        int rightCurrentPosition = 0;
        while (leftCurrentPosition < leftPositionCount && rightCurrentPosition < rightPositionCount) {
            if (leftArray.isNull(this.leftPositions[leftCurrentPosition]) || rightArray.isNull(this.rightPositions[rightCurrentPosition])) {
                return null;
            }
            int compareValue = type.compareTo(leftArray, this.leftPositions[leftCurrentPosition], rightArray, this.rightPositions[rightCurrentPosition]);
            if (compareValue > 0) {
                ++rightCurrentPosition;
                continue;
            }
            if (compareValue < 0) {
                ++leftCurrentPosition;
                continue;
            }
            return true;
        }
        return leftArray.isNull(this.leftPositions[leftPositionCount - 1]) || rightArray.isNull(this.rightPositions[rightPositionCount - 1]) ? null : Boolean.valueOf(false);
    }

    public Boolean genericArraysOverlap(Block leftArray, Block rightArray, AbstractType type) {
        int leftSize = leftArray.getPositionCount();
        int rightSize = rightArray.getPositionCount();
        if (leftSize == 0 || rightSize == 0) {
            return false;
        }
        if (this.leftLongArray == null || this.leftLongArray.length < leftSize) {
            this.leftLongArray = new long[leftSize * 2];
        }
        if (this.rightLongArray == null || this.rightLongArray.length < rightSize) {
            this.rightLongArray = new long[rightSize * 2];
        }
        int leftNonNullSize = ArraysOverlapFunction.sortAbstractLongArray(leftArray, this.leftLongArray, type);
        int rightNonNullSize = ArraysOverlapFunction.sortAbstractLongArray(rightArray, this.rightLongArray, type);
        int leftPosition = 0;
        int rightPosition = 0;
        while (leftPosition < leftNonNullSize && rightPosition < rightNonNullSize) {
            if (this.leftLongArray[leftPosition] < this.rightLongArray[rightPosition]) {
                ++leftPosition;
                continue;
            }
            if (this.rightLongArray[rightPosition] < this.leftLongArray[leftPosition]) {
                ++rightPosition;
                continue;
            }
            return true;
        }
        return leftNonNullSize < leftSize || rightNonNullSize < rightSize ? null : Boolean.valueOf(false);
    }

    private static int sortAbstractLongArray(Block array, long[] buffer, AbstractType type) {
        int i;
        int arraySize = array.getPositionCount();
        int nonNullSize = 0;
        for (i = 0; i < arraySize; ++i) {
            if (array.isNull(i)) continue;
            buffer[nonNullSize++] = type.getLong(array, i);
        }
        for (i = 1; i < nonNullSize; ++i) {
            if (buffer[i - 1] <= buffer[i]) continue;
            Arrays.sort(buffer, 0, nonNullSize);
            break;
        }
        return nonNullSize;
    }
}

