/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.ArrayMinMaxUtils;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_max")
@Description(value="Get maximum value of array")
public final class ArrayMaxFunction {
    private ArrayMaxFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Void arrayWithUnknownType(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @SqlType(value="array(T)") Block block) {
        return null;
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Long longArrayMax(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.longArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Boolean booleanArrayMax(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.booleanArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Double doubleArrayMax(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.doubleArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Slice sliceArrayMax(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.sliceArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Block blockArrayMax(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            Block selectedValue = (Block)elementType.getObject(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                Block value = (Block)elementType.getObject(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

