/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputParameterRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class InterpretedPageProjection
implements PageProjection {
    private final ExpressionInterpreter evaluator;
    private final InputChannels inputChannels;
    private final boolean deterministic;
    private BlockBuilder blockBuilder;

    public InterpretedPageProjection(Expression expression, Map<Symbol, Type> symbolTypes, Map<Symbol, Integer> symbolToInputMappings, Metadata metadata, SqlParser sqlParser, Session session) {
        SymbolToInputParameterRewriter rewriter = new SymbolToInputParameterRewriter(symbolTypes, symbolToInputMappings);
        Expression rewritten = rewriter.rewrite(expression);
        this.inputChannels = new InputChannels(rewriter.getInputChannels());
        this.deterministic = DeterminismEvaluator.isDeterministic(expression);
        List<Type> inputTypes = rewriter.getInputTypes();
        ImmutableMap.Builder parameterTypes = ImmutableMap.builder();
        for (int parameter = 0; parameter < inputTypes.size(); ++parameter) {
            Type type = inputTypes.get(parameter);
            parameterTypes.put((Object)parameter, (Object)type);
        }
        Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(session, metadata, sqlParser, (Map<Integer, Type>)parameterTypes.build(), rewritten, Collections.emptyList());
        this.evaluator = ExpressionInterpreter.expressionInterpreter(rewritten, metadata, session, expressionTypes);
        this.blockBuilder = this.evaluator.getType().createBlockBuilder(new BlockBuilderStatus(), 1);
    }

    @Override
    public Type getType() {
        return this.evaluator.getType();
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public Block project(ConnectorSession session, Page page, SelectedPositions selectedPositions) {
        if (selectedPositions.isList()) {
            this.project(page, selectedPositions.getPositions(), selectedPositions.getOffset(), selectedPositions.size());
        } else {
            this.project(page, selectedPositions.getOffset(), selectedPositions.size());
        }
        Block block = this.blockBuilder.build();
        this.blockBuilder = this.blockBuilder.newBlockBuilderLike(new BlockBuilderStatus());
        return block;
    }

    private void project(Page page, int[] selectedPositions, int offset, int length) {
        for (int index = offset; index < offset + length; ++index) {
            this.project(page, selectedPositions[index]);
        }
    }

    private void project(Page page, int offset, int length) {
        for (int position = offset; position < offset + length; ++position) {
            this.project(page, position);
        }
    }

    private void project(Page page, int position) {
        Object value = this.evaluator.evaluate(position, page.getBlocks());
        TypeUtils.writeNativeValue((Type)this.evaluator.getType(), (BlockBuilder)this.blockBuilder, (Object)value);
    }
}

