/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.CursorProcessor;
import com.facebook.presto.operator.project.CursorProcessorOutput;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputParameterRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class InterpretedCursorProcessor
implements CursorProcessor {
    @Nullable
    private final ExpressionInterpreter filter;
    private final List<ExpressionInterpreter> projections;
    private final List<Type> types;

    public InterpretedCursorProcessor(Optional<Expression> filter, List<Expression> projections, Map<Symbol, Type> symbolTypes, Map<Symbol, Integer> symbolToInputMappings, Metadata metadata, SqlParser sqlParser, Session session) {
        this.filter = filter.map(expression -> InterpretedCursorProcessor.getExpressionInterpreter(expression, symbolTypes, symbolToInputMappings, metadata, sqlParser, session)).orElse(null);
        this.projections = (List)projections.stream().map(expression -> InterpretedCursorProcessor.getExpressionInterpreter(expression, symbolTypes, symbolToInputMappings, metadata, sqlParser, session)).collect(ImmutableList.toImmutableList());
        this.types = (List)this.projections.stream().map(ExpressionInterpreter::getType).collect(ImmutableList.toImmutableList());
    }

    private static ExpressionInterpreter getExpressionInterpreter(Expression expression, Map<Symbol, Type> symbolTypes, Map<Symbol, Integer> symbolToInputMappings, Metadata metadata, SqlParser sqlParser, Session session) {
        SymbolToInputParameterRewriter rewriter = new SymbolToInputParameterRewriter(symbolTypes, symbolToInputMappings);
        Expression rewritten = rewriter.rewrite(expression);
        List<Type> inputTypes = rewriter.getInputTypes();
        ImmutableMap.Builder parameterTypes = ImmutableMap.builder();
        for (int parameter = 0; parameter < inputTypes.size(); ++parameter) {
            Type type = inputTypes.get(parameter);
            parameterTypes.put((Object)parameter, (Object)type);
        }
        Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(session, metadata, sqlParser, (Map<Integer, Type>)parameterTypes.build(), rewritten, Collections.emptyList());
        return ExpressionInterpreter.expressionInterpreter(rewritten, metadata, session, expressionTypes);
    }

    @Override
    public CursorProcessorOutput process(ConnectorSession session, DriverYieldSignal yieldSignal, RecordCursor cursor, PageBuilder pageBuilder) {
        Preconditions.checkArgument((!pageBuilder.isFull() ? 1 : 0) != 0, (Object)"page builder can't be full");
        Objects.requireNonNull(yieldSignal, "yieldSignal is null");
        int position = 0;
        while (!pageBuilder.isFull() && !yieldSignal.isSet()) {
            if (!cursor.advanceNextPosition()) {
                return new CursorProcessorOutput(position, true);
            }
            if (this.filter(cursor)) {
                pageBuilder.declarePosition();
                for (int channel = 0; channel < this.projections.size(); ++channel) {
                    this.project(cursor, channel, pageBuilder);
                }
            }
            ++position;
        }
        return new CursorProcessorOutput(position, false);
    }

    private boolean filter(RecordCursor cursor) {
        return this.filter == null || Boolean.TRUE.equals(this.filter.evaluate(cursor));
    }

    private void project(RecordCursor cursor, int channel, PageBuilder pageBuilder) {
        ExpressionInterpreter projection = this.projections.get(channel);
        Object value = projection.evaluate(cursor);
        TypeUtils.writeNativeValue((Type)this.types.get(channel), (BlockBuilder)pageBuilder.getBlockBuilder(channel), (Object)value);
    }
}

