/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.DictionaryId;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Verify;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class DictionaryAwarePageProjection
implements PageProjection {
    private final PageProjection projection;
    private final Function<DictionaryBlock, DictionaryId> sourceIdFunction;
    private Block lastInputDictionary;
    private Optional<Block> lastOutputDictionary;
    private long lastDictionaryUsageCount;

    public DictionaryAwarePageProjection(PageProjection projection, Function<DictionaryBlock, DictionaryId> sourceIdFunction) {
        this.projection = Objects.requireNonNull(projection, "projection is null");
        this.sourceIdFunction = sourceIdFunction;
        Verify.verify((boolean)projection.isDeterministic(), (String)"projection must be deterministic", (Object[])new Object[0]);
        Verify.verify((projection.getInputChannels().size() == 1 ? 1 : 0) != 0, (String)"projection must have only one input", (Object[])new Object[0]);
    }

    @Override
    public Type getType() {
        return this.projection.getType();
    }

    @Override
    public boolean isDeterministic() {
        return this.projection.isDeterministic();
    }

    @Override
    public InputChannels getInputChannels() {
        return this.projection.getInputChannels();
    }

    @Override
    public Block project(ConnectorSession session, Page page, SelectedPositions selectedPositions) {
        Block value;
        Optional<Block> projectedValue;
        Block block = page.getBlock(0);
        if (block instanceof LazyBlock) {
            block = ((LazyBlock)block).getBlock();
        }
        if (block instanceof RunLengthEncodedBlock && (projectedValue = this.processDictionary(session, value = ((RunLengthEncodedBlock)block).getValue())).isPresent()) {
            return new RunLengthEncodedBlock(projectedValue.get(), selectedPositions.size());
        }
        if (block instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            Optional<Block> projectedDictionary = this.processDictionary(session, dictionaryBlock.getDictionary());
            this.lastDictionaryUsageCount += (long)selectedPositions.size();
            if (projectedDictionary.isPresent()) {
                this.lastDictionaryUsageCount += (long)selectedPositions.size();
                int[] outputIds = DictionaryAwarePageProjection.filterDictionaryIds(dictionaryBlock, selectedPositions);
                return new DictionaryBlock(selectedPositions.size(), projectedDictionary.get(), outputIds, false, this.sourceIdFunction.apply(dictionaryBlock));
            }
        }
        return this.projection.project(session, new Page(new Block[]{block}), selectedPositions);
    }

    private Optional<Block> processDictionary(ConnectorSession session, Block dictionary) {
        if (this.lastInputDictionary == dictionary) {
            return this.lastOutputDictionary;
        }
        boolean shouldProcessDictionary = this.lastInputDictionary == null || dictionary.getPositionCount() == 1 || this.lastDictionaryUsageCount >= (long)this.lastInputDictionary.getPositionCount();
        this.lastDictionaryUsageCount = 0L;
        this.lastInputDictionary = dictionary;
        if (shouldProcessDictionary) {
            try {
                this.lastOutputDictionary = Optional.of(this.projection.project(session, new Page(new Block[]{dictionary}), SelectedPositions.positionsRange(0, dictionary.getPositionCount())));
            }
            catch (Exception ignored) {
                this.lastOutputDictionary = Optional.empty();
            }
        } else {
            this.lastOutputDictionary = Optional.empty();
        }
        return this.lastOutputDictionary;
    }

    private static int[] filterDictionaryIds(DictionaryBlock dictionaryBlock, SelectedPositions selectedPositions) {
        int[] outputIds = new int[selectedPositions.size()];
        if (selectedPositions.isList()) {
            int[] positions = selectedPositions.getPositions();
            int endPosition = selectedPositions.getOffset() + selectedPositions.size();
            int outputIndex = 0;
            for (int position = selectedPositions.getOffset(); position < endPosition; ++position) {
                outputIds[outputIndex++] = dictionaryBlock.getId(positions[position]);
            }
        } else {
            int endPosition = selectedPositions.getOffset() + selectedPositions.size();
            int outputIndex = 0;
            for (int position = selectedPositions.getOffset(); position < endPosition; ++position) {
                outputIds[outputIndex++] = dictionaryBlock.getId(position);
            }
        }
        return outputIds;
    }
}

