/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.index.IndexLoader;
import com.facebook.presto.operator.index.IndexedData;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IndexLookupSource
implements LookupSource {
    private final IndexLoader indexLoader;
    private IndexedData indexedData;

    public IndexLookupSource(IndexLoader indexLoader) {
        this.indexLoader = Objects.requireNonNull(indexLoader, "indexLoader is null");
        this.indexedData = indexLoader.getIndexSnapshot();
    }

    @Override
    public int getChannelCount() {
        return this.indexLoader.getChannelCount();
    }

    @Override
    public long getJoinPositionCount() {
        return 0L;
    }

    @Override
    public long getInMemorySizeInBytes() {
        return 0L;
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
        return this.getJoinPosition(position, hashChannelsPage, allChannelsPage);
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
        Block[] blocks = hashChannelsPage.getBlocks();
        long joinPosition = this.indexedData.getJoinPosition(position, hashChannelsPage);
        if (joinPosition == -2L) {
            this.indexedData.close();
            this.indexedData = this.indexLoader.getIndexedDataForKeys(position, blocks);
            joinPosition = this.indexedData.getJoinPosition(position, hashChannelsPage);
            Preconditions.checkState((joinPosition != -2L ? 1 : 0) != 0);
        }
        return joinPosition;
    }

    @Override
    public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        long nextPosition = this.indexedData.getNextJoinPosition(currentJoinPosition);
        Preconditions.checkState((nextPosition != -2L ? 1 : 0) != 0);
        return nextPosition;
    }

    @Override
    public boolean isJoinPositionEligible(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        return true;
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.indexedData.appendTo(position, pageBuilder, outputChannelOffset);
    }

    @Override
    public void close() {
        this.indexedData.close();
    }
}

