/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalExchangeMemoryManager {
    private static final SettableFuture<?> NOT_FULL = SettableFuture.create();
    private final long maxBufferedBytes;
    private final AtomicLong bufferedBytes = new AtomicLong();
    @GuardedBy(value="this")
    private SettableFuture<?> notFullFuture = NOT_FULL;
    private final AtomicBoolean blockOnFull = new AtomicBoolean(true);

    public LocalExchangeMemoryManager(long maxBufferedBytes) {
        Preconditions.checkArgument((maxBufferedBytes > 0L ? 1 : 0) != 0, (Object)"maxBufferedBytes must be > 0");
        this.maxBufferedBytes = maxBufferedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMemoryUsage(long bytesAdded) {
        SettableFuture<?> future;
        LocalExchangeMemoryManager localExchangeMemoryManager = this;
        synchronized (localExchangeMemoryManager) {
            this.bufferedBytes.addAndGet(bytesAdded);
            if (this.bufferedBytes.get() > this.maxBufferedBytes || this.notFullFuture.isDone()) {
                return;
            }
            future = this.notFullFuture;
            this.notFullFuture = NOT_FULL;
        }
        future.set(null);
    }

    public synchronized ListenableFuture<?> getNotFullFuture() {
        if (this.bufferedBytes.get() > this.maxBufferedBytes && this.blockOnFull.get() && this.notFullFuture.isDone()) {
            this.notFullFuture = SettableFuture.create();
        }
        return this.notFullFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoBlockOnFull() {
        SettableFuture<?> future;
        this.blockOnFull.set(false);
        LocalExchangeMemoryManager localExchangeMemoryManager = this;
        synchronized (localExchangeMemoryManager) {
            if (this.notFullFuture.isDone()) {
                return;
            }
            future = this.notFullFuture;
            this.notFullFuture = NOT_FULL;
        }
        future.set(null);
    }

    public long getBufferedBytes() {
        return this.bufferedBytes.get();
    }

    static {
        NOT_FULL.set(null);
    }
}

