/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.builder;

import com.facebook.presto.memory.LocalMemoryContext;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.builder.InMemoryHashAggregationBuilder;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class MergingHashAggregationBuilder
implements Closeable {
    private final List<AccumulatorFactory> accumulatorFactories;
    private final AggregationNode.Step step;
    private final int expectedGroups;
    private final ImmutableList<Integer> groupByPartialChannels;
    private final Optional<Integer> hashChannel;
    private final OperatorContext operatorContext;
    private final Iterator<Page> sortedPages;
    private InMemoryHashAggregationBuilder hashAggregationBuilder;
    private final List<Type> groupByTypes;
    private final LocalMemoryContext systemMemoryContext;
    private final long memoryLimitForMerge;
    private final int overwriteIntermediateChannelOffset;
    private final JoinCompiler joinCompiler;

    public MergingHashAggregationBuilder(List<AccumulatorFactory> accumulatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, Optional<Integer> hashChannel, OperatorContext operatorContext, Iterator<Page> sortedPages, LocalMemoryContext systemMemoryContext, long memoryLimitForMerge, int overwriteIntermediateChannelOffset, JoinCompiler joinCompiler) {
        ImmutableList.Builder groupByPartialChannels = ImmutableList.builder();
        for (int i = 0; i < groupByTypes.size(); ++i) {
            groupByPartialChannels.add((Object)i);
        }
        this.accumulatorFactories = accumulatorFactories;
        this.step = AggregationNode.Step.partialInput(step);
        this.expectedGroups = expectedGroups;
        this.groupByPartialChannels = groupByPartialChannels.build();
        this.hashChannel = hashChannel.isPresent() ? Optional.of(groupByTypes.size()) : hashChannel;
        this.operatorContext = operatorContext;
        this.sortedPages = sortedPages;
        this.groupByTypes = groupByTypes;
        this.systemMemoryContext = systemMemoryContext;
        this.memoryLimitForMerge = memoryLimitForMerge;
        this.overwriteIntermediateChannelOffset = overwriteIntermediateChannelOffset;
        this.joinCompiler = joinCompiler;
        this.rebuildHashAggregationBuilder();
    }

    public Iterator<Page> buildResult() {
        return new Iterator<Page>(){
            private Iterator<Page> resultPages = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                return MergingHashAggregationBuilder.this.sortedPages.hasNext() || this.resultPages.hasNext();
            }

            @Override
            public Page next() {
                if (!this.resultPages.hasNext()) {
                    MergingHashAggregationBuilder.this.rebuildHashAggregationBuilder();
                    long memorySize = 0L;
                    while (MergingHashAggregationBuilder.this.sortedPages.hasNext() && !MergingHashAggregationBuilder.this.shouldProduceOutput(memorySize)) {
                        MergingHashAggregationBuilder.this.hashAggregationBuilder.processPage((Page)MergingHashAggregationBuilder.this.sortedPages.next());
                        memorySize = MergingHashAggregationBuilder.this.hashAggregationBuilder.getSizeInMemory();
                        MergingHashAggregationBuilder.this.systemMemoryContext.setBytes(memorySize);
                    }
                    this.resultPages = MergingHashAggregationBuilder.this.hashAggregationBuilder.buildResult();
                }
                return this.resultPages.next();
            }
        };
    }

    @Override
    public void close() {
        this.hashAggregationBuilder.close();
    }

    private boolean shouldProduceOutput(long memorySize) {
        return this.memoryLimitForMerge > 0L && memorySize > this.memoryLimitForMerge;
    }

    private void rebuildHashAggregationBuilder() {
        this.hashAggregationBuilder = new InMemoryHashAggregationBuilder(this.accumulatorFactories, this.step, this.expectedGroups, this.groupByTypes, (List<Integer>)this.groupByPartialChannels, this.hashChannel, this.operatorContext, DataSize.succinctBytes((long)0L), Optional.of(this.overwriteIntermediateChannelOffset), this.joinCompiler);
    }
}

