/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.builder;

import com.facebook.presto.array.IntBigArray;
import com.facebook.presto.memory.LocalMemoryContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.HashCollisionsCounter;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.builder.HashAggregationBuilder;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InMemoryHashAggregationBuilder
implements HashAggregationBuilder {
    private final GroupByHash groupByHash;
    private final List<Aggregator> aggregators;
    private final OperatorContext operatorContext;
    private final boolean partial;
    private final long maxPartialMemory;
    private final LocalMemoryContext systemMemoryContext;
    private boolean full;

    public InMemoryHashAggregationBuilder(List<AccumulatorFactory> accumulatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, OperatorContext operatorContext, DataSize maxPartialMemory, JoinCompiler joinCompiler) {
        this(accumulatorFactories, step, expectedGroups, groupByTypes, groupByChannels, hashChannel, operatorContext, maxPartialMemory, Optional.empty(), joinCompiler);
    }

    public InMemoryHashAggregationBuilder(List<AccumulatorFactory> accumulatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, OperatorContext operatorContext, DataSize maxPartialMemory, Optional<Integer> overwriteIntermediateChannelOffset, JoinCompiler joinCompiler) {
        this.groupByHash = GroupByHash.createGroupByHash(operatorContext.getSession(), groupByTypes, Ints.toArray(groupByChannels), hashChannel, expectedGroups, joinCompiler);
        this.operatorContext = operatorContext;
        this.partial = step.isOutputPartial();
        this.maxPartialMemory = maxPartialMemory.toBytes();
        this.systemMemoryContext = operatorContext.getSystemMemoryContext().newLocalMemoryContext();
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null");
        for (int i = 0; i < accumulatorFactories.size(); ++i) {
            AccumulatorFactory accumulatorFactory = accumulatorFactories.get(i);
            Optional<Object> overwriteIntermediateChannel = Optional.empty();
            if (overwriteIntermediateChannelOffset.isPresent()) {
                overwriteIntermediateChannel = Optional.of(overwriteIntermediateChannelOffset.get() + i);
            }
            builder.add((Object)new Aggregator(accumulatorFactory, step, overwriteIntermediateChannel));
        }
        this.aggregators = builder.build();
    }

    @Override
    public void close() {
        if (this.partial) {
            this.systemMemoryContext.setBytes(0L);
        } else {
            this.operatorContext.setMemoryReservation(0L);
        }
    }

    @Override
    public void processPage(Page page) {
        if (this.aggregators.isEmpty()) {
            this.groupByHash.addPage(page);
        } else {
            GroupByIdBlock groupIds = this.groupByHash.getGroupIds(page);
            for (Aggregator aggregator : this.aggregators) {
                aggregator.processPage(groupIds, page);
            }
        }
    }

    @Override
    public void updateMemory() {
        long memorySize = this.getSizeInMemory();
        if (this.partial) {
            this.systemMemoryContext.setBytes(memorySize);
            this.full = memorySize > this.maxPartialMemory;
        } else {
            this.operatorContext.setMemoryReservation(memorySize);
        }
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public void recordHashCollisions(HashCollisionsCounter hashCollisionsCounter) {
        hashCollisionsCounter.recordHashCollision(this.groupByHash.getHashCollisions(), this.groupByHash.getExpectedHashCollisions());
    }

    public long getHashCollisions() {
        return this.groupByHash.getHashCollisions();
    }

    public double getExpectedHashCollisions() {
        return this.groupByHash.getExpectedHashCollisions();
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        throw new UnsupportedOperationException("startMemoryRevoke not supported for InMemoryHashAggregationBuilder");
    }

    @Override
    public void finishMemoryRevoke() {
        throw new UnsupportedOperationException("finishMemoryRevoke not supported for InMemoryHashAggregationBuilder");
    }

    public long getSizeInMemory() {
        long sizeInMemory = this.groupByHash.getEstimatedSize();
        for (Aggregator aggregator : this.aggregators) {
            sizeInMemory += aggregator.getEstimatedSize();
        }
        return sizeInMemory;
    }

    public long getGroupIdsSortingSize() {
        return this.getGroupCount() * 4L;
    }

    public void setOutputPartial() {
        for (Aggregator aggregator : this.aggregators) {
            aggregator.setOutputPartial();
        }
    }

    public int getKeyChannels() {
        return this.groupByHash.getTypes().size();
    }

    public long getGroupCount() {
        return this.groupByHash.getGroupCount();
    }

    @Override
    public Iterator<Page> buildResult() {
        return this.buildResult(this.consecutiveGroupIds());
    }

    public Iterator<Page> buildHashSortedResult() {
        return this.buildResult(this.hashSortedGroupIds());
    }

    public List<Type> buildIntermediateTypes() {
        ArrayList<Type> types = new ArrayList<Type>(this.groupByHash.getTypes());
        for (Aggregator aggregator : this.aggregators) {
            types.add(aggregator.getIntermediateType());
        }
        return types;
    }

    private Iterator<Page> buildResult(final IntIterator groupIds) {
        final PageBuilder pageBuilder = new PageBuilder(this.buildTypes());
        return new AbstractIterator<Page>(){

            protected Page computeNext() {
                if (!groupIds.hasNext()) {
                    return (Page)this.endOfData();
                }
                pageBuilder.reset();
                List<Type> types = InMemoryHashAggregationBuilder.this.groupByHash.getTypes();
                while (!pageBuilder.isFull() && groupIds.hasNext()) {
                    int groupId = groupIds.nextInt();
                    InMemoryHashAggregationBuilder.this.groupByHash.appendValuesTo(groupId, pageBuilder, 0);
                    pageBuilder.declarePosition();
                    for (int i = 0; i < InMemoryHashAggregationBuilder.this.aggregators.size(); ++i) {
                        Aggregator aggregator = (Aggregator)InMemoryHashAggregationBuilder.this.aggregators.get(i);
                        BlockBuilder output = pageBuilder.getBlockBuilder(types.size() + i);
                        aggregator.evaluate(groupId, output);
                    }
                }
                return pageBuilder.build();
            }
        };
    }

    public List<Type> buildTypes() {
        ArrayList<Type> types = new ArrayList<Type>(this.groupByHash.getTypes());
        for (Aggregator aggregator : this.aggregators) {
            types.add(aggregator.getType());
        }
        return types;
    }

    private IntIterator consecutiveGroupIds() {
        return IntIterators.fromTo((int)0, (int)this.groupByHash.getGroupCount());
    }

    private IntIterator hashSortedGroupIds() {
        final IntBigArray groupIds = new IntBigArray();
        groupIds.ensureCapacity((long)this.groupByHash.getGroupCount());
        for (int i = 0; i < this.groupByHash.getGroupCount(); ++i) {
            groupIds.set((long)i, i);
        }
        groupIds.sort(0, this.groupByHash.getGroupCount(), (leftGroupId, rightGroupId) -> Long.compare(this.groupByHash.getRawHash(leftGroupId), this.groupByHash.getRawHash(rightGroupId)));
        return new AbstractIntIterator(){
            private final int totalPositions;
            private int position;
            {
                this.totalPositions = InMemoryHashAggregationBuilder.this.groupByHash.getGroupCount();
                this.position = 0;
            }

            public boolean hasNext() {
                return this.position < this.totalPositions;
            }

            public int nextInt() {
                return groupIds.get((long)this.position++);
            }
        };
    }

    public static List<Type> toTypes(List<? extends Type> groupByType, AggregationNode.Step step, List<AccumulatorFactory> factories, Optional<Integer> hashChannel) {
        ImmutableList.Builder types = ImmutableList.builder();
        types.addAll(groupByType);
        if (hashChannel.isPresent()) {
            types.add((Object)BigintType.BIGINT);
        }
        for (AccumulatorFactory factory : factories) {
            types.add((Object)new Aggregator(factory, step, Optional.empty()).getType());
        }
        return types.build();
    }

    private static class Aggregator {
        private final GroupedAccumulator aggregation;
        private AggregationNode.Step step;
        private final int intermediateChannel;

        private Aggregator(AccumulatorFactory accumulatorFactory, AggregationNode.Step step, Optional<Integer> overwriteIntermediateChannel) {
            if (step.isInputRaw()) {
                this.intermediateChannel = -1;
                this.aggregation = accumulatorFactory.createGroupedAccumulator();
            } else if (overwriteIntermediateChannel.isPresent()) {
                this.intermediateChannel = overwriteIntermediateChannel.get();
                this.aggregation = accumulatorFactory.createGroupedIntermediateAccumulator();
            } else {
                Preconditions.checkArgument((accumulatorFactory.getInputChannels().size() == 1 ? 1 : 0) != 0, (Object)"expected 1 input channel for intermediate aggregation");
                this.intermediateChannel = accumulatorFactory.getInputChannels().get(0);
                this.aggregation = accumulatorFactory.createGroupedIntermediateAccumulator();
            }
            this.step = step;
        }

        public long getEstimatedSize() {
            return this.aggregation.getEstimatedSize();
        }

        public Type getType() {
            if (this.step.isOutputPartial()) {
                return this.aggregation.getIntermediateType();
            }
            return this.aggregation.getFinalType();
        }

        public void processPage(GroupByIdBlock groupIds, Page page) {
            if (this.step.isInputRaw()) {
                this.aggregation.addInput(groupIds, page);
            } else {
                this.aggregation.addIntermediate(groupIds, page.getBlock(this.intermediateChannel));
            }
        }

        public void evaluate(int groupId, BlockBuilder output) {
            if (this.step.isOutputPartial()) {
                this.aggregation.evaluateIntermediate(groupId, output);
            } else {
                this.aggregation.evaluateFinal(groupId, output);
            }
        }

        public void setOutputPartial() {
            this.step = AggregationNode.Step.partialOutput(this.step);
        }

        public Type getIntermediateType() {
            return this.aggregation.getIntermediateType();
        }
    }
}

