/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.array.IntBigArray;
import com.facebook.presto.array.LongBigArray;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class TypedHistogram {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TypedHistogram.class).instanceSize();
    private static final float FILL_RATIO = 0.9f;
    private static final long FOUR_MEGABYTES = new DataSize(4.0, DataSize.Unit.MEGABYTE).toBytes();
    private int hashCapacity;
    private int maxFill;
    private int mask;
    private final Type type;
    private final BlockBuilder values;
    private IntBigArray hashPositions;
    private final LongBigArray counts;

    public TypedHistogram(Type type, int expectedSize) {
        this.type = type;
        Preconditions.checkArgument((expectedSize > 0 ? 1 : 0) != 0, (Object)"expectedSize must be greater than zero");
        this.hashCapacity = HashCommon.arraySize((int)expectedSize, (float)0.9f);
        this.maxFill = TypedHistogram.calculateMaxFill(this.hashCapacity);
        this.mask = this.hashCapacity - 1;
        this.values = this.type.createBlockBuilder(null, this.hashCapacity);
        this.hashPositions = new IntBigArray(-1);
        this.hashPositions.ensureCapacity((long)this.hashCapacity);
        this.counts = new LongBigArray();
        this.counts.ensureCapacity((long)this.hashCapacity);
    }

    public TypedHistogram(Block block, Type type, int expectedSize) {
        this(type, expectedSize);
        Objects.requireNonNull(block, "block is null");
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            this.add(i, block, BigintType.BIGINT.getLong(block, i + 1));
        }
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.values.getRetainedSizeInBytes() + this.counts.sizeOf() + this.hashPositions.sizeOf();
    }

    private Block getValues() {
        return this.values.build();
    }

    private LongBigArray getCounts() {
        return this.counts;
    }

    public void serialize(BlockBuilder out) {
        Block valuesBlock = this.values.build();
        BlockBuilder blockBuilder = out.beginBlockEntry();
        for (int i = 0; i < valuesBlock.getPositionCount(); ++i) {
            this.type.appendTo(valuesBlock, i, blockBuilder);
            BigintType.BIGINT.writeLong(blockBuilder, this.counts.get((long)i));
        }
        out.closeEntry();
    }

    public void addAll(TypedHistogram other) {
        Block otherValues = other.getValues();
        LongBigArray otherCounts = other.getCounts();
        for (int i = 0; i < otherValues.getPositionCount(); ++i) {
            long count = otherCounts.get((long)i);
            if (count <= 0L) continue;
            this.add(i, otherValues, count);
        }
    }

    public void add(int position, Block block, long count) {
        int hashPosition = TypedHistogram.getHashPosition(TypeUtils.hashPosition(this.type, block, position), this.mask);
        while (this.hashPositions.get((long)hashPosition) != -1) {
            if (this.type.equalTo(block, position, (Block)this.values, this.hashPositions.get((long)hashPosition))) {
                this.counts.add((long)this.hashPositions.get((long)hashPosition), count);
                return;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        this.addNewGroup(hashPosition, position, block, count);
    }

    private void addNewGroup(int hashPosition, int position, Block block, long count) {
        this.hashPositions.set((long)hashPosition, this.values.getPositionCount());
        this.counts.set((long)this.values.getPositionCount(), count);
        this.type.appendTo(block, position, this.values);
        if (this.values.getPositionCount() >= this.maxFill) {
            this.rehash();
        }
        if (this.getEstimatedSize() > FOUR_MEGABYTES) {
            throw ExceededMemoryLimitException.exceededLocalLimit(new DataSize(4.0, DataSize.Unit.MEGABYTE));
        }
    }

    private void rehash() {
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        int newCapacity = (int)newCapacityLong;
        int newMask = newCapacity - 1;
        IntBigArray newHashPositions = new IntBigArray(-1);
        newHashPositions.ensureCapacity((long)newCapacity);
        for (int i = 0; i < this.values.getPositionCount(); ++i) {
            int hashPosition = TypedHistogram.getHashPosition(TypeUtils.hashPosition(this.type, (Block)this.values, i), newMask);
            while (newHashPositions.get((long)hashPosition) != -1) {
                hashPosition = hashPosition + 1 & newMask;
            }
            newHashPositions.set((long)hashPosition, i);
        }
        this.hashCapacity = newCapacity;
        this.mask = newMask;
        this.maxFill = TypedHistogram.calculateMaxFill(newCapacity);
        this.hashPositions = newHashPositions;
        this.counts.ensureCapacity((long)this.maxFill);
    }

    private static int getHashPosition(long rawHash, int mask) {
        return (int)HashCommon.murmurHash3((long)rawHash) & mask;
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must be greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.9f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
        return maxFill;
    }
}

