/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.MinMaxHelper;
import com.facebook.presto.operator.aggregation.state.BlockState;
import com.facebook.presto.operator.aggregation.state.BlockStateSerializer;
import com.facebook.presto.operator.aggregation.state.NullableBooleanState;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.operator.aggregation.state.SliceState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.AggregationStateSerializerFactory;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

@AggregationFunction(value="max")
@Description(value="Returns the maximum value of the argument")
public class MaxAggregationFunction {
    private MaxAggregationFunction() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle methodHandle, @AggregationState NullableDoubleState state, @SqlType(value="T") double value) {
        MinMaxHelper.combineStateWithValue(methodHandle, state, value);
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle methodHandle, @AggregationState NullableLongState state, @SqlType(value="T") long value) {
        MinMaxHelper.combineStateWithValue(methodHandle, state, value);
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle methodHandle, @AggregationState SliceState state, @SqlType(value="T") Slice value) {
        MinMaxHelper.combineStateWithValue(methodHandle, state, value);
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle methodHandle, @AggregationState NullableBooleanState state, @SqlType(value="T") boolean value) {
        MinMaxHelper.combineStateWithValue(methodHandle, state, value);
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle methodHandle, @AggregationState BlockState state, @SqlType(value="T") Block value) {
        MinMaxHelper.combineStateWithValue(methodHandle, state, value);
    }

    @CombineFunction
    public static void combine(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle methodHandle, @AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        MinMaxHelper.combineStateWithState(methodHandle, state, otherState);
    }

    @CombineFunction
    public static void combine(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle methodHandle, @AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        MinMaxHelper.combineStateWithState(methodHandle, state, otherState);
    }

    @CombineFunction
    public static void combine(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle methodHandle, @AggregationState NullableBooleanState state, @AggregationState NullableBooleanState otherState) {
        MinMaxHelper.combineStateWithState(methodHandle, state, otherState);
    }

    @CombineFunction
    public static void combine(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle methodHandle, @AggregationState SliceState state, @AggregationState SliceState otherState) {
        MinMaxHelper.combineStateWithState(methodHandle, state, otherState);
    }

    @CombineFunction
    public static void combine(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle methodHandle, @AggregationState BlockState state, @AggregationState BlockState otherState) {
        MinMaxHelper.combineStateWithState(methodHandle, state, otherState);
    }

    @OutputFunction(value="T")
    @TypeParameter(value="T")
    public static void output(@TypeParameter(value="T") Type type, @AggregationState NullableLongState state, BlockBuilder out) {
        NullableLongState.write(type, state, out);
    }

    @OutputFunction(value="T")
    @TypeParameter(value="T")
    public static void output(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        NullableDoubleState.write(type, state, out);
    }

    @OutputFunction(value="T")
    @TypeParameter(value="T")
    public static void output(@TypeParameter(value="T") Type type, @AggregationState NullableBooleanState state, BlockBuilder out) {
        NullableBooleanState.write(type, state, out);
    }

    @OutputFunction(value="T")
    @TypeParameter(value="T")
    public static void output(@TypeParameter(value="T") Type type, @AggregationState SliceState state, BlockBuilder out) {
        SliceState.write(type, state, out);
    }

    @OutputFunction(value="T")
    @TypeParameter(value="T")
    public static void output(@TypeParameter(value="T") Type type, @AggregationState BlockState state, BlockBuilder out) {
        BlockState.write(type, state, out);
    }

    @AggregationStateSerializerFactory(value=BlockState.class)
    @TypeParameter(value="T")
    public static AccumulatorStateSerializer<?> getStateSerializer(@TypeParameter(value="T") Type type) {
        return new BlockStateSerializer(type);
    }
}

