/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.NestedLoopJoinPages;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class NestedLoopJoinPagesSupplier {
    private final List<Type> types;
    private final SettableFuture<NestedLoopJoinPages> pagesFuture = SettableFuture.create();
    private final AtomicInteger referenceCount = new AtomicInteger(0);

    public NestedLoopJoinPagesSupplier(List<Type> types) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public ListenableFuture<NestedLoopJoinPages> getPagesFuture() {
        return Futures.transformAsync(this.pagesFuture, Futures::immediateFuture);
    }

    public void setPages(NestedLoopJoinPages nestedLoopJoinPages) {
        Objects.requireNonNull(nestedLoopJoinPages, "nestedLoopJoinPages is null");
        boolean wasSet = this.pagesFuture.set((Object)nestedLoopJoinPages);
        Preconditions.checkState((boolean)wasSet, (Object)"pagesFuture already set");
    }

    public void retain() {
        this.referenceCount.incrementAndGet();
    }

    public void release() {
        if (this.referenceCount.decrementAndGet() == 0) {
            Futures.addCallback(this.pagesFuture, (FutureCallback)new FutureCallback<NestedLoopJoinPages>(){

                public void onSuccess(NestedLoopJoinPages result) {
                    result.freeMemory();
                }

                public void onFailure(Throwable t) {
                }
            });
        }
    }
}

