/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OuterPositionIterator;
import com.facebook.presto.operator.ReferenceCount;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class LookupOuterOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final ListenableFuture<OuterPositionIterator> outerPositionsFuture;
    private final List<Type> types;
    private final List<Type> probeOutputTypes;
    private final Runnable onClose;
    private final PageBuilder pageBuilder;
    private OuterPositionIterator outerPositions;
    private boolean closed;

    public LookupOuterOperator(OperatorContext operatorContext, ListenableFuture<OuterPositionIterator> outerPositionsFuture, List<Type> probeOutputTypes, List<Type> buildOutputTypes, Runnable onClose) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.outerPositionsFuture = Objects.requireNonNull(outerPositionsFuture, "outerPositionsFuture is null");
        this.types = ImmutableList.builder().addAll((Iterable)Objects.requireNonNull(probeOutputTypes, "probeOutputTypes is null")).addAll((Iterable)Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null")).build();
        this.probeOutputTypes = ImmutableList.copyOf(probeOutputTypes);
        this.pageBuilder = new PageBuilder(this.types);
        this.onClose = Objects.requireNonNull(onClose, "onClose is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.outerPositionsFuture;
    }

    @Override
    public void finish() {
        this.close();
    }

    @Override
    public boolean isFinished() {
        return this.closed;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (this.outerPositions == null) {
            this.outerPositions = MoreFutures.tryGetFutureValue(this.outerPositionsFuture).orElse(null);
            if (this.outerPositions == null) {
                return null;
            }
        }
        boolean outputPositionsFinished = false;
        while (!this.pageBuilder.isFull()) {
            boolean bl = outputPositionsFinished = !this.outerPositions.appendToNext(this.pageBuilder, this.probeOutputTypes.size());
            if (outputPositionsFinished) break;
            this.pageBuilder.declarePosition();
            for (int probeChannel = 0; probeChannel < this.probeOutputTypes.size(); ++probeChannel) {
                this.pageBuilder.getBlockBuilder(probeChannel).appendNull();
            }
        }
        Page page = null;
        if (this.pageBuilder.isFull() || outputPositionsFinished && !this.pageBuilder.isEmpty()) {
            page = this.pageBuilder.build();
            this.pageBuilder.reset();
        }
        if (outputPositionsFinished) {
            this.close();
        }
        return page;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.pageBuilder.reset();
        this.onClose.run();
    }

    public static class LookupOuterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final ListenableFuture<OuterPositionIterator> outerPositionsFuture;
        private final List<Type> types;
        private final List<Type> probeOutputTypes;
        private final List<Type> buildOutputTypes;
        private final ReferenceCount referenceCount;
        private State state = State.NOT_CREATED;

        public LookupOuterOperatorFactory(int operatorId, PlanNodeId planNodeId, ListenableFuture<OuterPositionIterator> outerPositionsFuture, List<Type> probeOutputTypes, List<Type> buildOutputTypes, ReferenceCount referenceCount) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.outerPositionsFuture = Objects.requireNonNull(outerPositionsFuture, "outerPositionsFuture is null");
            this.probeOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeOutputTypes, "probeOutputTypes is null"));
            this.buildOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null"));
            this.referenceCount = Objects.requireNonNull(referenceCount, "referenceCount is null");
            this.types = ImmutableList.builder().addAll(probeOutputTypes).addAll(buildOutputTypes).build();
        }

        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((this.state == State.NOT_CREATED ? 1 : 0) != 0, (Object)"Only one outer operator can be created");
            this.state = State.CREATED;
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LookupOuterOperator.class.getSimpleName());
            this.referenceCount.retain();
            return new LookupOuterOperator(operatorContext, this.outerPositionsFuture, this.probeOutputTypes, this.buildOutputTypes, this.referenceCount::release);
        }

        @Override
        public void close() {
            if (this.state == State.CLOSED) {
                return;
            }
            this.state = State.CLOSED;
            this.referenceCount.release();
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Source operator factories can not be duplicated");
        }

        private static enum State {
            NOT_CREATED,
            CREATED,
            CLOSED;

        }
    }
}

