/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinOperatorFactory;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupJoinOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupOuterOperator;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OuterPositionIterator;
import com.facebook.presto.operator.ReferenceCount;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LookupJoinOperatorFactory
implements JoinOperatorFactory {
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final List<Type> probeTypes;
    private final List<Type> probeOutputTypes;
    private final List<Type> buildTypes;
    private final List<Type> buildOutputTypes;
    private final LookupJoinOperators.JoinType joinType;
    private final LookupSourceFactory lookupSourceFactory;
    private final JoinProbeFactory joinProbeFactory;
    private final Optional<OperatorFactory> outerOperatorFactory;
    private final ReferenceCount probeReferenceCount;
    private final ReferenceCount lookupSourceFactoryUsersCount;
    private boolean closed;

    public LookupJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, LookupSourceFactory lookupSourceFactory, List<Type> probeTypes, List<Type> probeOutputTypes, LookupJoinOperators.JoinType joinType, JoinProbeFactory joinProbeFactory) {
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.lookupSourceFactory = Objects.requireNonNull(lookupSourceFactory, "lookupSourceFactory is null");
        this.probeTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeTypes, "probeTypes is null"));
        this.probeOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeOutputTypes, "probeOutputTypes is null"));
        this.buildTypes = ImmutableList.copyOf(lookupSourceFactory.getTypes());
        this.buildOutputTypes = ImmutableList.copyOf(lookupSourceFactory.getOutputTypes());
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
        this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
        this.probeReferenceCount = new ReferenceCount();
        this.lookupSourceFactoryUsersCount = new ReferenceCount();
        this.lookupSourceFactoryUsersCount.getFreeFuture().addListener(lookupSourceFactory::destroy, MoreExecutors.directExecutor());
        this.probeReferenceCount.getFreeFuture().addListener(this.lookupSourceFactoryUsersCount::release, MoreExecutors.directExecutor());
        if (joinType == LookupJoinOperators.JoinType.INNER || joinType == LookupJoinOperators.JoinType.PROBE_OUTER) {
            this.outerOperatorFactory = Optional.empty();
        } else {
            ListenableFuture lookupSourceAfterProbeFinished = Futures.transformAsync(this.probeReferenceCount.getFreeFuture(), ignored -> lookupSourceFactory.createLookupSource());
            ListenableFuture outerPositionsFuture = Futures.transform((ListenableFuture)lookupSourceAfterProbeFinished, lookupSource -> {
                lookupSource.close();
                return lookupSourceFactory.getOuterPositionIterator();
            });
            this.lookupSourceFactoryUsersCount.retain();
            this.outerOperatorFactory = Optional.of(new LookupOuterOperator.LookupOuterOperatorFactory(operatorId, planNodeId, (ListenableFuture<OuterPositionIterator>)outerPositionsFuture, probeOutputTypes, this.buildOutputTypes, this.lookupSourceFactoryUsersCount));
        }
    }

    private LookupJoinOperatorFactory(LookupJoinOperatorFactory other) {
        Objects.requireNonNull(other, "other is null");
        this.operatorId = other.operatorId;
        this.planNodeId = other.planNodeId;
        this.probeTypes = other.probeTypes;
        this.probeOutputTypes = other.probeOutputTypes;
        this.buildTypes = other.buildTypes;
        this.buildOutputTypes = other.buildOutputTypes;
        this.joinType = other.joinType;
        this.lookupSourceFactory = other.lookupSourceFactory;
        this.joinProbeFactory = other.joinProbeFactory;
        this.probeReferenceCount = other.probeReferenceCount;
        this.lookupSourceFactoryUsersCount = other.lookupSourceFactoryUsersCount;
        this.outerOperatorFactory = other.outerOperatorFactory;
        this.probeReferenceCount.retain();
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.builder().addAll(this.probeOutputTypes).addAll(this.buildOutputTypes).build();
    }

    @Override
    public Operator createOperator(DriverContext driverContext) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
        OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LookupJoinOperator.class.getSimpleName());
        this.lookupSourceFactory.setTaskContext(driverContext.getPipelineContext().getTaskContext());
        this.probeReferenceCount.retain();
        return new LookupJoinOperator(operatorContext, this.getTypes(), this.joinType, this.lookupSourceFactory.createLookupSource(), this.joinProbeFactory, this.probeReferenceCount::release);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.probeReferenceCount.release();
    }

    @Override
    public OperatorFactory duplicate() {
        return new LookupJoinOperatorFactory(this);
    }

    @Override
    public Optional<OperatorFactory> createOuterOperatorFactory() {
        return this.outerOperatorFactory;
    }
}

