/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.util.Mergeable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

public class JoinOperatorInfo
implements Mergeable<JoinOperatorInfo>,
OperatorInfo {
    private final LookupJoinOperators.JoinType joinType;
    private final long[] logHistogramProbes;
    private final long[] logHistogramOutput;
    private final long lookupSourcePositions;

    public static JoinOperatorInfo createJoinOperatorInfo(LookupJoinOperators.JoinType joinType, long[] logHistogramCounters, long lookupSourcePositions) {
        long[] logHistogramProbes = new long[8];
        long[] logHistogramOutput = new long[8];
        for (int i = 0; i < 8; ++i) {
            logHistogramProbes[i] = logHistogramCounters[2 * i];
            logHistogramOutput[i] = logHistogramCounters[2 * i + 1];
        }
        return new JoinOperatorInfo(joinType, logHistogramProbes, logHistogramOutput, lookupSourcePositions);
    }

    @JsonCreator
    public JoinOperatorInfo(@JsonProperty(value="joinType") LookupJoinOperators.JoinType joinType, @JsonProperty(value="logHistogramProbes") long[] logHistogramProbes, @JsonProperty(value="logHistogramOutput") long[] logHistogramOutput, @JsonProperty(value="lookupSourcePositions") long lookupSourcePositions) {
        Preconditions.checkArgument((logHistogramProbes.length == 8 ? 1 : 0) != 0);
        Preconditions.checkArgument((logHistogramOutput.length == 8 ? 1 : 0) != 0);
        this.joinType = joinType;
        this.logHistogramProbes = logHistogramProbes;
        this.logHistogramOutput = logHistogramOutput;
        this.lookupSourcePositions = lookupSourcePositions;
    }

    @JsonProperty
    public LookupJoinOperators.JoinType getJoinType() {
        return this.joinType;
    }

    @JsonProperty
    public long[] getLogHistogramProbes() {
        return this.logHistogramProbes;
    }

    @JsonProperty
    public long[] getLogHistogramOutput() {
        return this.logHistogramOutput;
    }

    @JsonProperty
    public long getLookupSourcePositions() {
        return this.lookupSourcePositions;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("joinType", (Object)this.joinType).add("logHistogramProbes", (Object)this.logHistogramProbes).add("logHistogramOutput", (Object)this.logHistogramOutput).add("lookupSourcePositions", this.lookupSourcePositions).toString();
    }

    @Override
    public JoinOperatorInfo mergeWith(JoinOperatorInfo other) {
        Preconditions.checkState((boolean)this.joinType.equals((Object)other.joinType), (Object)"different join types");
        long[] logHistogramProbes = new long[8];
        long[] logHistogramOutput = new long[8];
        for (int i = 0; i < 8; ++i) {
            logHistogramProbes[i] = this.logHistogramProbes[i] + other.logHistogramProbes[i];
            logHistogramOutput[i] = this.logHistogramOutput[i] + other.logHistogramOutput[i];
        }
        return new JoinOperatorInfo(this.joinType, logHistogramProbes, logHistogramOutput, this.lookupSourcePositions + other.lookupSourcePositions);
    }

    @Override
    public boolean isFinal() {
        return true;
    }
}

