/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.operator.ArrayPositionLinks;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.JoinHash;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.PagesHash;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PositionLinks;
import com.facebook.presto.operator.SortedPositionLinks;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JoinHashSupplier
implements LookupSourceSupplier {
    private final Session session;
    private final PagesHash pagesHash;
    private final LongArrayList addresses;
    private final List<List<Block>> channels;
    private final Optional<PositionLinks.Factory> positionLinks;
    private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
    private final List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories;

    public JoinHashSupplier(Session session, PagesHashStrategy pagesHashStrategy, LongArrayList addresses, List<List<Block>> channels, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories) {
        PositionLinks.FactoryBuilder positionLinksFactoryBuilder;
        this.session = Objects.requireNonNull(session, "session is null");
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.channels = Objects.requireNonNull(channels, "channels is null");
        this.filterFunctionFactory = Objects.requireNonNull(filterFunctionFactory, "filterFunctionFactory is null");
        this.searchFunctionFactories = ImmutableList.copyOf(searchFunctionFactories);
        Objects.requireNonNull(pagesHashStrategy, "pagesHashStrategy is null");
        if (sortChannel.isPresent() && SystemSessionProperties.isFastInequalityJoin(session)) {
            Preconditions.checkArgument((boolean)filterFunctionFactory.isPresent(), (Object)"filterFunctionFactory not set while sortChannel set");
            positionLinksFactoryBuilder = SortedPositionLinks.builder(addresses.size(), pagesHashStrategy, addresses);
        } else {
            positionLinksFactoryBuilder = ArrayPositionLinks.builder(addresses.size());
        }
        this.pagesHash = new PagesHash(addresses, pagesHashStrategy, positionLinksFactoryBuilder);
        this.positionLinks = positionLinksFactoryBuilder.isEmpty() ? Optional.empty() : Optional.of(positionLinksFactoryBuilder.build());
    }

    @Override
    public long getHashCollisions() {
        return this.pagesHash.getHashCollisions();
    }

    @Override
    public double getExpectedHashCollisions() {
        return this.pagesHash.getExpectedHashCollisions();
    }

    @Override
    public JoinHash get() {
        Optional<JoinFilterFunction> filterFunction = this.filterFunctionFactory.map(factory -> factory.create(this.session.toConnectorSession(), this.addresses, this.channels));
        return new JoinHash(this.pagesHash, filterFunction, this.positionLinks.map(links -> {
            List searchFunctions = (List)this.searchFunctionFactories.stream().map(factory -> factory.create(this.session.toConnectorSession(), this.addresses, this.channels)).collect(ImmutableList.toImmutableList());
            return links.create(searchFunctions);
        }));
    }
}

