/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.ExceededSpillLimitException;
import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContextVisitor;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class QueryContext {
    private static final long GUARANTEED_MEMORY = new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes();
    private final QueryId queryId;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final long maxSpill;
    private final SpillSpaceTracker spillSpaceTracker;
    private final Map<TaskId, TaskContext> taskContexts = new ConcurrentHashMap<TaskId, TaskContext>();
    private final MemoryPool systemMemoryPool;
    @GuardedBy(value="this")
    private long maxMemory;
    @GuardedBy(value="this")
    private long reserved;
    @GuardedBy(value="this")
    private long revocableReserved;
    @GuardedBy(value="this")
    private MemoryPool memoryPool;
    @GuardedBy(value="this")
    private long systemReserved;
    @GuardedBy(value="this")
    private long spillUsed;

    public QueryContext(QueryId queryId, DataSize maxMemory, MemoryPool memoryPool, MemoryPool systemMemoryPool, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, DataSize maxSpill, SpillSpaceTracker spillSpaceTracker) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null").toBytes();
        this.memoryPool = Objects.requireNonNull(memoryPool, "memoryPool is null");
        this.systemMemoryPool = Objects.requireNonNull(systemMemoryPool, "systemMemoryPool is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "yieldExecutor is null");
        this.maxSpill = Objects.requireNonNull(maxSpill, "maxSpill is null").toBytes();
        this.spillSpaceTracker = Objects.requireNonNull(spillSpaceTracker, "spillSpaceTracker is null");
    }

    public synchronized void setResourceOvercommit() {
        this.maxMemory = this.memoryPool.getMaxBytes();
    }

    public synchronized ListenableFuture<?> reserveMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        if (this.reserved + bytes > this.maxMemory) {
            throw ExceededMemoryLimitException.exceededLocalLimit(DataSize.succinctBytes((long)this.maxMemory));
        }
        ListenableFuture<?> future = this.memoryPool.reserve(this.queryId, bytes);
        this.reserved += bytes;
        if (this.reserved < GUARANTEED_MEMORY) {
            return Operator.NOT_BLOCKED;
        }
        return future;
    }

    public synchronized ListenableFuture<?> reserveRevocableMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        ListenableFuture<?> future = this.memoryPool.reserveRevocable(this.queryId, bytes);
        this.revocableReserved += bytes;
        return future;
    }

    public synchronized ListenableFuture<?> reserveSystemMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        ListenableFuture<?> future = this.systemMemoryPool.reserve(this.queryId, bytes);
        this.systemReserved += bytes;
        return future;
    }

    public synchronized ListenableFuture<?> reserveSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        if (this.spillUsed + bytes > this.maxSpill) {
            throw ExceededSpillLimitException.exceededPerQueryLocalLimit(DataSize.succinctBytes((long)this.maxSpill));
        }
        ListenableFuture<?> future = this.spillSpaceTracker.reserve(bytes);
        this.spillUsed += bytes;
        return future;
    }

    public synchronized boolean tryReserveMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        if (this.reserved + bytes > this.maxMemory) {
            return false;
        }
        if (this.memoryPool.tryReserve(this.queryId, bytes)) {
            this.reserved += bytes;
            return true;
        }
        return false;
    }

    public synchronized void freeMemory(long bytes) {
        Preconditions.checkArgument((this.reserved - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.reserved -= bytes;
        this.memoryPool.free(this.queryId, bytes);
    }

    public synchronized void freeRevocableMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((this.revocableReserved - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more revocable memory than is reserved");
        this.revocableReserved -= bytes;
        this.memoryPool.freeRevocable(this.queryId, bytes);
    }

    public synchronized void freeSystemMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((this.systemReserved - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more system memory than is reserved");
        this.systemReserved -= bytes;
        this.systemMemoryPool.free(this.queryId, bytes);
    }

    public synchronized void freeSpill(long bytes) {
        Preconditions.checkArgument((this.spillUsed - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.spillUsed -= bytes;
        this.spillSpaceTracker.free(bytes);
    }

    public synchronized void setMemoryPool(MemoryPool pool) {
        Objects.requireNonNull(pool, "pool is null");
        if (pool.getId().equals((Object)this.memoryPool.getId())) {
            return;
        }
        final MemoryPool originalPool = this.memoryPool;
        final long originalReserved = this.reserved + this.revocableReserved;
        this.memoryPool = pool;
        ListenableFuture<?> future = pool.reserve(this.queryId, originalReserved);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                originalPool.free(QueryContext.this.queryId, originalReserved);
                QueryContext.this.taskContexts.values().forEach(TaskContext::moreMemoryAvailable);
            }

            public void onFailure(Throwable t) {
                originalPool.free(QueryContext.this.queryId, originalReserved);
                QueryContext.this.taskContexts.values().forEach(TaskContext::moreMemoryAvailable);
            }
        });
    }

    public synchronized MemoryPool getMemoryPool() {
        return this.memoryPool;
    }

    public TaskContext addTaskContext(TaskStateMachine taskStateMachine, Session session, boolean verboseStats, boolean cpuTimerEnabled) {
        TaskContext taskContext = new TaskContext(this, taskStateMachine, this.notificationExecutor, this.yieldExecutor, session, verboseStats, cpuTimerEnabled);
        this.taskContexts.put(taskStateMachine.getTaskId(), taskContext);
        return taskContext;
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitQueryContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.taskContexts.values().stream().map(taskContext -> taskContext.accept(visitor, context)).collect(Collectors.toList());
    }

    public TaskContext getTaskContextByTaskId(TaskId taskId) {
        TaskContext taskContext = this.taskContexts.get(taskId);
        Verify.verify((taskContext != null ? 1 : 0) != 0, (String)"task does not exist", (Object[])new Object[0]);
        return taskContext;
    }
}

