/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.execution.SystemMemoryUsageListener;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class OutputBufferMemoryManager {
    private final long maxBufferedBytes;
    private final AtomicLong bufferedBytes = new AtomicLong();
    @GuardedBy(value="this")
    private SettableFuture<?> notFull;
    private final AtomicBoolean blockOnFull = new AtomicBoolean(true);
    private final SystemMemoryUsageListener systemMemoryUsageListener;
    private final Executor notificationExecutor;

    public OutputBufferMemoryManager(long maxBufferedBytes, SystemMemoryUsageListener systemMemoryUsageListener, Executor notificationExecutor) {
        Preconditions.checkArgument((maxBufferedBytes > 0L ? 1 : 0) != 0, (Object)"maxBufferedBytes must be > 0");
        this.maxBufferedBytes = maxBufferedBytes;
        this.systemMemoryUsageListener = Objects.requireNonNull(systemMemoryUsageListener, "systemMemoryUsageListener is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.notFull = SettableFuture.create();
        this.notFull.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMemoryUsage(long bytesAdded) {
        this.systemMemoryUsageListener.updateSystemMemoryUsage(bytesAdded);
        this.bufferedBytes.addAndGet(bytesAdded);
        OutputBufferMemoryManager outputBufferMemoryManager = this;
        synchronized (outputBufferMemoryManager) {
            if (!this.isFull() && !this.notFull.isDone()) {
                SettableFuture<?> future = this.notFull;
                this.notificationExecutor.execute(() -> future.set(null));
            }
        }
    }

    public synchronized ListenableFuture<?> getNotFullFuture() {
        if (this.isFull() && this.notFull.isDone()) {
            this.notFull = SettableFuture.create();
        }
        return this.notFull;
    }

    public synchronized void setNoBlockOnFull() {
        this.blockOnFull.set(false);
        SettableFuture<?> future = this.notFull;
        this.notificationExecutor.execute(() -> future.set(null));
    }

    public long getBufferedBytes() {
        return this.bufferedBytes.get();
    }

    public double getUtilization() {
        return (double)this.bufferedBytes.get() / (double)this.maxBufferedBytes;
    }

    private boolean isFull() {
        return this.bufferedBytes.get() > this.maxBufferedBytes && this.blockOnFull.get();
    }
}

