/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.predicate.NullableValue;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InformationSchemaSplit
implements ConnectorSplit {
    private final InformationSchemaTableHandle tableHandle;
    private final Map<String, NullableValue> filters;
    private final List<HostAddress> addresses;

    @JsonCreator
    public InformationSchemaSplit(@JsonProperty(value="tableHandle") InformationSchemaTableHandle tableHandle, @JsonProperty(value="filters") Map<String, NullableValue> filters, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.filters = Objects.requireNonNull(filters, "filters is null");
        Objects.requireNonNull(addresses, "hosts is null");
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"hosts is empty");
        this.addresses = ImmutableList.copyOf(addresses);
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public InformationSchemaTableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public Map<String, NullableValue> getFilters() {
        return this.filters;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).add("filters", this.filters).add("addresses", this.addresses).toString();
    }
}

