/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.util.Reflection;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.lang.invoke.MethodHandle;

public final class BlockSerdeUtil {
    public static final MethodHandle READ_BLOCK = Reflection.methodHandle(BlockSerdeUtil.class, "readBlock", BlockEncodingSerde.class, Slice.class);

    private BlockSerdeUtil() {
    }

    public static Block readBlock(BlockEncodingSerde blockEncodingSerde, Slice slice) {
        return BlockSerdeUtil.readBlock(blockEncodingSerde, (SliceInput)slice.getInput());
    }

    public static Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput input) {
        BlockEncoding blockEncoding = blockEncodingSerde.readBlockEncoding(input);
        return blockEncoding.readBlock(input);
    }

    public static void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput output, Block block) {
        BlockEncoding encoding = block.getEncoding();
        blockEncodingSerde.writeBlockEncoding(output, encoding);
        encoding.writeBlock(output, block);
    }

    public static void writeBlock(SliceOutput output, Block block) {
        BlockEncoding encoding = block.getEncoding();
        BlockEncodingManager.writeBlockEncodingInternal(output, encoding);
        encoding.writeBlock(output, block);
    }
}

