/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FullConnectorSession
implements ConnectorSession {
    private final String queryId;
    private final Identity identity;
    private final Optional<String> source;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final long startTime;
    private final Map<String, String> properties;
    private final ConnectorId connectorId;
    private final String catalog;
    private final SessionPropertyManager sessionPropertyManager;

    public FullConnectorSession(String queryId, Identity identity, Optional<String> source, TimeZoneKey timeZoneKey, Locale locale, long startTime) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.startTime = startTime;
        this.properties = null;
        this.connectorId = null;
        this.catalog = null;
        this.sessionPropertyManager = null;
    }

    public FullConnectorSession(String queryId, Identity identity, Optional<String> source, TimeZoneKey timeZoneKey, Locale locale, long startTime, Map<String, String> properties, ConnectorId connectorId, String catalog, SessionPropertyManager sessionPropertyManager) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.startTime = startTime;
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
    }

    public String getQueryId() {
        return this.queryId;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public <T> T getProperty(String propertyName, Class<T> type) {
        if (this.properties == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Unknown session property: %s.%s", this.catalog, propertyName));
        }
        return this.sessionPropertyManager.decodeCatalogPropertyValue(this.connectorId, this.catalog, propertyName, this.properties.get(propertyName), type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("queryId", (Object)this.queryId).add("user", (Object)this.getUser()).add("source", this.source.orElse(null)).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("startTime", this.startTime).add("properties", this.properties).omitNullValues().toString();
    }
}

