/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util.maps;

import com.google.common.base.Equivalence;
import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class IdentityLinkedHashMap<K, V>
implements Map<K, V> {
    private final Map<Equivalence.Wrapper<K>, V> delegate = new LinkedHashMap<Equivalence.Wrapper<K>, V>();
    private final Equivalence<Object> equivalence = Equivalence.identity();

    public IdentityLinkedHashMap() {
    }

    public IdentityLinkedHashMap(IdentityLinkedHashMap<K, V> map) {
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(this.equivalence.wrap(key));
    }

    @Override
    @Deprecated
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(this.equivalence.wrap(key));
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(this.equivalence.wrap(key), value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(this.equivalence.wrap(key));
    }

    @Override
    @Deprecated
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.entrySet().forEach((? super T e) -> this.delegate.put(this.equivalence.wrap(e.getKey()), e.getValue()));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public IterateOnlySetView<K> keySet() {
        return new IterateOnlySetView<K>(){

            @Override
            public Iterator<K> iterator() {
                return IdentityLinkedHashMap.this.delegate.keySet().stream().map(Equivalence.Wrapper::get).iterator();
            }
        };
    }

    @Override
    public IterateOnlyCollectionView<V> values() {
        return new IterateOnlyCollectionView<V>(){

            @Override
            public Iterator<V> iterator() {
                return Iterators.unmodifiableIterator(IdentityLinkedHashMap.this.delegate.values().iterator());
            }
        };
    }

    @Override
    public IterateOnlySetView<Map.Entry<K, V>> entrySet() {
        return new IterateOnlySetView<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return IdentityLinkedHashMap.this.delegate.entrySet().stream().map(e -> {
                    Object key = ((Equivalence.Wrapper)e.getKey()).get();
                    return new AbstractMap.SimpleEntry(key, e.getValue());
                }).iterator();
            }
        };
    }

    public abstract class IterateOnlyCollectionView<E>
    implements Collection<E> {
        private IterateOnlyCollectionView() {
        }

        @Override
        public int size() {
            return IdentityLinkedHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        @Deprecated
        public boolean contains(Object item) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return Iterators.toArray(this.iterator(), Object.class);
        }

        @Override
        @Deprecated
        public <T> T[] toArray(T[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean add(E item) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean remove(Object item) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean containsAll(Collection<?> other) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean addAll(Collection<? extends E> other) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean retainAll(Collection<?> other) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean removeAll(Collection<?> other) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.stream().map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
        }

        @Override
        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean equals(Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    public abstract class IterateOnlySetView<E>
    extends IterateOnlyCollectionView<E>
    implements Set<E> {
        private IterateOnlySetView() {
        }
    }
}

