/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.execution.SqlQueryManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class ExplainRewrite
implements StatementRewrite.Rewrite {
    ExplainRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, AccessControl accessControl) {
        return (Statement)new Visitor(session, parser, queryExplainer).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final SqlParser parser;
        private final Optional<QueryExplainer> queryExplainer;

        public Visitor(Session session, SqlParser parser, Optional<QueryExplainer> queryExplainer) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.parser = parser;
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
        }

        protected Node visitExplain(Explain node, Void context) throws SemanticException {
            if (node.isAnalyze()) {
                Statement statement = (Statement)this.process((Node)node.getStatement(), context);
                return new Explain(statement, node.isAnalyze(), node.getOptions());
            }
            ExplainType.Type planType = ExplainType.Type.LOGICAL;
            ExplainFormat.Type planFormat = ExplainFormat.Type.TEXT;
            List options = node.getOptions();
            for (ExplainOption option : options) {
                if (!(option instanceof ExplainType)) continue;
                planType = ((ExplainType)option).getType();
                break;
            }
            for (ExplainOption option : options) {
                if (!(option instanceof ExplainFormat)) continue;
                planFormat = ((ExplainFormat)option).getType();
                break;
            }
            return this.getQueryPlan(node, planType, planFormat);
        }

        private Node getQueryPlan(Explain node, ExplainType.Type planType, ExplainFormat.Type planFormat) throws IllegalArgumentException {
            String plan;
            Statement wrappedStatement = node.getStatement();
            Statement statement = SqlQueryManager.unwrapExecuteStatement(wrappedStatement, this.parser, this.session);
            List parameters = wrappedStatement instanceof Execute ? ((Execute)wrappedStatement).getParameters() : Collections.emptyList();
            SqlQueryManager.validateParameters(statement, parameters);
            if (planType == ExplainType.Type.VALIDATE) {
                this.queryExplainer.get().analyze(this.session, statement, parameters);
                return QueryUtil.singleValueQuery((String)"Valid", (boolean)true);
            }
            switch (planFormat) {
                case GRAPHVIZ: {
                    plan = this.queryExplainer.get().getGraphvizPlan(this.session, statement, planType, parameters);
                    break;
                }
                case TEXT: {
                    plan = this.queryExplainer.get().getPlan(this.session, statement, planType, parameters);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Explain Format: " + planFormat.toString());
                }
            }
            return QueryUtil.singleValueQuery((String)"Query Plan", (String)plan);
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

