/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.DescribeOutput;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class DescribeOutputRewrite
implements StatementRewrite.Rewrite {
    DescribeOutputRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, AccessControl accessControl) {
        return (Statement)new Visitor(session, parser, metadata, queryExplainer, parameters, accessControl).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final SqlParser parser;
        private final Metadata metadata;
        private final Optional<QueryExplainer> queryExplainer;
        private final List<Expression> parameters;
        private final AccessControl accessControl;

        public Visitor(Session session, SqlParser parser, Metadata metadata, Optional<QueryExplainer> queryExplainer, List<Expression> parameters, AccessControl accessControl) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.parser = parser;
            this.metadata = metadata;
            this.queryExplainer = queryExplainer;
            this.parameters = parameters;
            this.accessControl = accessControl;
        }

        protected Node visitDescribeOutput(DescribeOutput node, Void context) {
            String sqlString = this.session.getPreparedStatement(node.getName());
            Statement statement = this.parser.createStatement(sqlString);
            Analyzer analyzer = new Analyzer(this.session, this.metadata, this.parser, this.accessControl, this.queryExplainer, this.parameters);
            Analysis analysis = analyzer.analyze(statement, true);
            Optional<Object> limit = Optional.empty();
            Row[] rows = (Row[])analysis.getRootScope().getRelationType().getVisibleFields().stream().map(field -> Visitor.createDescribeOutputRow(field, analysis)).toArray(Row[]::new);
            if (rows.length == 0) {
                NullLiteral nullLiteral = new NullLiteral();
                rows = new Row[]{QueryUtil.row((Expression[])new Expression[]{nullLiteral, nullLiteral, nullLiteral, nullLiteral, nullLiteral, nullLiteral, nullLiteral})};
                limit = Optional.of("0");
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"Column Name"), QueryUtil.identifier((String)"Catalog"), QueryUtil.identifier((String)"Schema"), QueryUtil.identifier((String)"Table"), QueryUtil.identifier((String)"Type"), QueryUtil.identifier((String)"Type Size"), QueryUtil.identifier((String)"Aliased")}), (Relation)QueryUtil.aliased((Relation)QueryUtil.values((Row[])rows), (String)"Statement Output", (List)ImmutableList.of((Object)"Column Name", (Object)"Catalog", (Object)"Schema", (Object)"Table", (Object)"Type", (Object)"Type Size", (Object)"Aliased")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), limit);
        }

        private static Row createDescribeOutputRow(Field field, Analysis analysis) {
            String columnName;
            LongLiteral typeSize = new LongLiteral("0");
            if (field.getType() instanceof FixedWidthType) {
                typeSize = new LongLiteral(String.valueOf(((FixedWidthType)field.getType()).getFixedSize()));
            }
            if (field.getName().isPresent()) {
                columnName = field.getName().get();
            } else {
                int columnIndex = ImmutableList.copyOf(analysis.getOutputDescriptor().getVisibleFields()).indexOf((Object)field);
                columnName = "_col" + columnIndex;
            }
            Optional<QualifiedObjectName> originTable = field.getOriginTable();
            return QueryUtil.row((Expression[])new Expression[]{new StringLiteral(columnName), new StringLiteral(originTable.map(QualifiedObjectName::getCatalogName).orElse("")), new StringLiteral(originTable.map(QualifiedObjectName::getSchemaName).orElse("")), new StringLiteral(originTable.map(QualifiedObjectName::getObjectName).orElse("")), new StringLiteral(field.getType().getDisplayName()), typeSize, new BooleanLiteral(String.valueOf(field.isAliased()))});
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

