/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class PlanRewriter<C, P>
extends PlanVisitor<RewriteContext<C, P>, Result<P>> {
    public static <C, P> Result<P> rewriteWith(PlanRewriter<C, P> rewriter, PlanNode node) {
        return (Result)node.accept(rewriter, new RewriteContext(rewriter, null));
    }

    public static <C, P> Result<P> rewriteWith(PlanRewriter<C, P> rewriter, PlanNode node, C context) {
        return (Result)node.accept(rewriter, new RewriteContext(rewriter, context));
    }

    @Override
    protected Result<P> visitPlan(PlanNode node, RewriteContext<C, P> context) {
        return context.defaultRewrite(node, context.get());
    }

    public static class RewriteContext<C, P> {
        private final C userContext;
        private final PlanRewriter<C, P> nodeRewriter;

        private RewriteContext(PlanRewriter<C, P> nodeRewriter, @Nullable C userContext) {
            this.nodeRewriter = Objects.requireNonNull(nodeRewriter, "nodeRewriter is null");
            this.userContext = userContext;
        }

        public C get() {
            return this.userContext;
        }

        public Result<P> defaultRewrite(PlanNode node) {
            return this.defaultRewrite(node, null, payloads -> null);
        }

        public Result<P> defaultRewrite(PlanNode node, C context) {
            return this.defaultRewrite(node, context, payloads -> null);
        }

        public Result<P> defaultRewrite(PlanNode node, Function<List<P>, P> payloadCombiner) {
            return this.defaultRewrite(node, null, payloadCombiner);
        }

        public Result<P> defaultRewrite(PlanNode node, C context, Function<List<P>, P> payloadCombiner) {
            ArrayList<PlanNode> children = new ArrayList<PlanNode>(node.getSources().size());
            ArrayList<P> payloads = new ArrayList<P>(node.getSources().size());
            for (PlanNode source : node.getSources()) {
                Result<P> result = this.rewrite(source, context);
                children.add(result.getPlanNode());
                payloads.add(result.getPayload());
            }
            return new Result<P>(ChildReplacer.replaceChildren(node, children), payloadCombiner.apply(payloads));
        }

        public Result<P> rewrite(PlanNode node, C userContext) {
            Result result = (Result)node.accept(this.nodeRewriter, new RewriteContext<C, P>(this.nodeRewriter, userContext));
            Objects.requireNonNull(result, String.format("nodeRewriter returned null for %s", node.getClass().getName()));
            return result;
        }

        public Result<P> rewrite(PlanNode node) {
            return this.rewrite(node, null);
        }
    }

    public static class Result<P> {
        private final PlanNode planNode;
        private final P payload;

        public Result(PlanNode planNode, @Nullable P payload) {
            this.planNode = Objects.requireNonNull(planNode, "planNode is null");
            this.payload = payload;
        }

        public PlanNode getPlanNode() {
            return this.planNode;
        }

        public P getPayload() {
            return this.payload;
        }
    }
}

