/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AggregationNode
extends PlanNode {
    private final PlanNode source;
    private final Map<Symbol, Aggregation> assignments;
    private final List<List<Symbol>> groupingSets;
    private final Step step;
    private final Optional<Symbol> hashSymbol;
    private final Optional<Symbol> groupIdSymbol;
    private final List<Symbol> outputs;

    public boolean hasEmptyGroupingSet() {
        return this.groupingSets.stream().anyMatch(List::isEmpty);
    }

    public boolean hasNonEmptyGroupingSet() {
        return this.groupingSets.stream().anyMatch(symbols -> !symbols.isEmpty());
    }

    @JsonCreator
    public AggregationNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="assignments") Map<Symbol, Aggregation> assignments, @JsonProperty(value="groupingSets") List<List<Symbol>> groupingSets, @JsonProperty(value="step") Step step, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol, @JsonProperty(value="groupIdSymbol") Optional<Symbol> groupIdSymbol) {
        super(id);
        this.source = source;
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "aggregations is null"));
        Objects.requireNonNull(groupingSets, "groupingSets is null");
        Preconditions.checkArgument((!groupingSets.isEmpty() ? 1 : 0) != 0, (Object)"grouping sets list cannot be empty");
        this.groupingSets = ImmutableList.copyOf(groupingSets);
        this.step = step;
        this.hashSymbol = hashSymbol;
        this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol);
        ImmutableList.Builder outputs = ImmutableList.builder();
        outputs.addAll(this.getGroupingKeys());
        hashSymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)outputs).add(arg_0));
        outputs.addAll(assignments.keySet());
        this.outputs = outputs.build();
    }

    @Deprecated
    public AggregationNode(PlanNodeId id, PlanNode source, Map<Symbol, FunctionCall> assignments, Map<Symbol, Signature> functions, Map<Symbol, Symbol> masks, List<List<Symbol>> groupingSets, Step step, Optional<Symbol> hashSymbol, Optional<Symbol> groupIdSymbol) {
        this(id, source, AggregationNode.makeAssignments(assignments, functions, masks), groupingSets, step, hashSymbol, groupIdSymbol);
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty
    public Map<Symbol, Aggregation> getAssignments() {
        return this.assignments;
    }

    @Deprecated
    public Map<Symbol, FunctionCall> getAggregations() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Symbol, Aggregation> entry : this.assignments.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getCall());
        }
        return builder.build();
    }

    @Deprecated
    public Map<Symbol, Signature> getFunctions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Symbol, Aggregation> entry : this.assignments.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getSignature());
        }
        return builder.build();
    }

    @Deprecated
    public Map<Symbol, Symbol> getMasks() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Symbol, Aggregation> entry : this.assignments.entrySet()) {
            entry.getValue().getMask().ifPresent(symbol -> builder.put(entry.getKey(), symbol));
        }
        return builder.build();
    }

    public List<Symbol> getGroupingKeys() {
        ArrayList<Symbol> symbols = new ArrayList<Symbol>(this.groupingSets.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()));
        this.groupIdSymbol.ifPresent(symbols::add);
        return symbols;
    }

    @JsonProperty(value="groupingSets")
    public List<List<Symbol>> getGroupingSets() {
        return this.groupingSets;
    }

    public boolean hasDefaultOutput() {
        return this.hasEmptyGroupingSet() && (this.step.isOutputPartial() || this.step.equals((Object)Step.SINGLE));
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="step")
    public Step getStep() {
        return this.step;
    }

    @JsonProperty(value="hashSymbol")
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @JsonProperty(value="groupIdSymbol")
    public Optional<Symbol> getGroupIdSymbol() {
        return this.groupIdSymbol;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new AggregationNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.assignments, this.groupingSets, this.step, this.hashSymbol, this.groupIdSymbol);
    }

    public boolean isDecomposable(FunctionRegistry functionRegistry) {
        return this.getFunctions().values().stream().map(functionRegistry::getAggregateFunctionImplementation).allMatch(InternalAggregationFunction::isDecomposable);
    }

    private static Map<Symbol, Aggregation> makeAssignments(Map<Symbol, FunctionCall> aggregations, Map<Symbol, Signature> functions, Map<Symbol, Symbol> masks) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Symbol, FunctionCall> entry : aggregations.entrySet()) {
            Symbol output = entry.getKey();
            builder.put((Object)output, (Object)new Aggregation(entry.getValue(), functions.get(output), Optional.ofNullable(masks.get(output))));
        }
        return builder.build();
    }

    public static class Aggregation {
        private final FunctionCall call;
        private final Signature signature;
        private final Optional<Symbol> mask;

        @JsonCreator
        public Aggregation(@JsonProperty(value="call") FunctionCall call, @JsonProperty(value="signature") Signature signature, @JsonProperty(value="mask") Optional<Symbol> mask) {
            this.call = call;
            this.signature = signature;
            this.mask = mask;
        }

        @JsonProperty
        public FunctionCall getCall() {
            return this.call;
        }

        @JsonProperty
        public Signature getSignature() {
            return this.signature;
        }

        @JsonProperty
        public Optional<Symbol> getMask() {
            return this.mask;
        }
    }

    public static enum Step {
        PARTIAL(true, true),
        FINAL(false, false),
        INTERMEDIATE(false, true),
        SINGLE(true, false);

        private final boolean inputRaw;
        private final boolean outputPartial;

        private Step(boolean inputRaw, boolean outputPartial) {
            this.inputRaw = inputRaw;
            this.outputPartial = outputPartial;
        }

        public boolean isInputRaw() {
            return this.inputRaw;
        }

        public boolean isOutputPartial() {
            return this.outputPartial;
        }

        public static Step partialOutput(Step step) {
            if (step.isInputRaw()) {
                return PARTIAL;
            }
            return INTERMEDIATE;
        }

        public static Step partialInput(Step step) {
            if (step.isOutputPartial()) {
                return INTERMEDIATE;
            }
            return FINAL;
        }
    }
}

