/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SymbolMapper {
    private final Map<Symbol, Symbol> mapping;

    public SymbolMapper(Map<Symbol, Symbol> mapping) {
        this.mapping = ImmutableMap.copyOf(Objects.requireNonNull(mapping, "mapping is null"));
    }

    public Symbol map(Symbol symbol) {
        Symbol canonical = symbol;
        while (this.mapping.containsKey(canonical) && !this.mapping.get(canonical).equals(canonical)) {
            canonical = this.mapping.get(canonical);
        }
        return canonical;
    }

    public Expression map(Expression value) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Symbol canonical = SymbolMapper.this.map(Symbol.from((Expression)node));
                return canonical.toSymbolReference();
            }
        }, (Expression)value);
    }

    public AggregationNode map(AggregationNode node, PlanNode source) {
        return this.map(node, source, node.getId());
    }

    public AggregationNode map(AggregationNode node, PlanNode source, PlanNodeIdAllocator idAllocator) {
        return this.map(node, source, idAllocator.getNextId());
    }

    private AggregationNode map(AggregationNode node, PlanNode source, PlanNodeId newNodeId) {
        ImmutableMap.Builder functionInfos = ImmutableMap.builder();
        ImmutableMap.Builder functionCalls = ImmutableMap.builder();
        ImmutableMap.Builder masks = ImmutableMap.builder();
        for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
            Symbol symbol = entry.getKey();
            Symbol canonical = this.map(symbol);
            FunctionCall canonicalCall = (FunctionCall)this.map((Expression)entry.getValue());
            functionCalls.put((Object)canonical, (Object)canonicalCall);
            functionInfos.put((Object)canonical, (Object)node.getFunctions().get(symbol));
        }
        for (Map.Entry<Symbol, Object> entry : node.getMasks().entrySet()) {
            masks.put((Object)this.map(entry.getKey()), (Object)this.map((Symbol)entry.getValue()));
        }
        List groupingSets = (List)node.getGroupingSets().stream().map(this::mapAndDistinct).collect(ImmutableList.toImmutableList());
        return new AggregationNode(newNodeId, source, (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, Signature>)functionInfos.build(), (Map<Symbol, Symbol>)masks.build(), groupingSets, node.getStep(), node.getHashSymbol().map(this::map), node.getGroupIdSymbol().map(this::map));
    }

    private List<Symbol> mapAndDistinct(List<Symbol> outputs) {
        HashSet<Symbol> added = new HashSet<Symbol>();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : outputs) {
            Symbol canonical = this.map(symbol);
            if (!added.add(canonical)) continue;
            builder.add((Object)canonical);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableMap.Builder<Symbol, Symbol> mappings = ImmutableMap.builder();

        public SymbolMapper build() {
            return new SymbolMapper((Map<Symbol, Symbol>)this.mappings.build());
        }

        public void put(Symbol from, Symbol to) {
            this.mappings.put((Object)from, (Object)to);
        }
    }
}

