/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MergeWindows
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan, ImmutableListMultimap.of());
    }

    private static class Rewriter
    extends SimplePlanRewriter<Multimap<WindowNode.Specification, WindowNode>> {
        private Rewriter() {
        }

        @Override
        protected PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Multimap<WindowNode.Specification, WindowNode>> context) {
            PlanNode newNode = context.defaultRewrite(node, (Multimap<WindowNode.Specification, WindowNode>)ImmutableListMultimap.of());
            return Rewriter.collapseWindowsWithinSpecification(context.get(), newNode);
        }

        @Override
        public PlanNode visitWindow(WindowNode windowNode, SimplePlanRewriter.RewriteContext<Multimap<WindowNode.Specification, WindowNode>> context) {
            Preconditions.checkState((!windowNode.getHashSymbol().isPresent() ? 1 : 0) != 0, (Object)"MergeWindows should be run before HashGenerationOptimizer");
            Preconditions.checkState((windowNode.getPrePartitionedInputs().isEmpty() && windowNode.getPreSortedOrderPrefix() == 0 ? 1 : 0) != 0, (Object)"MergeWindows should be run before AddExchanges");
            Preconditions.checkState((windowNode.getWindowFunctions().values().stream().distinct().count() == 1L ? 1 : 0) != 0, (Object)"Frames expected to be identical");
            for (WindowNode.Specification specification : context.get().keySet()) {
                Collection nodes = context.get().get((Object)specification);
                if (!nodes.stream().anyMatch(node -> Rewriter.dependsOn(node, windowNode))) continue;
                return Rewriter.collapseWindowsWithinSpecification(context.get(), context.rewrite(windowNode.getSource(), (Multimap<WindowNode.Specification, WindowNode>)ImmutableListMultimap.of((Object)windowNode.getSpecification(), (Object)windowNode)));
            }
            return context.rewrite(windowNode.getSource(), (Multimap<WindowNode.Specification, WindowNode>)ImmutableListMultimap.builder().put((Object)windowNode.getSpecification(), (Object)windowNode).putAll(context.get()).build());
        }

        private static PlanNode collapseWindowsWithinSpecification(Multimap<WindowNode.Specification, WindowNode> windowsMap, PlanNode sourceNode) {
            for (WindowNode.Specification specification : windowsMap.keySet()) {
                Collection windows = windowsMap.get((Object)specification);
                sourceNode = Rewriter.collapseWindows(sourceNode, specification, windows);
            }
            return sourceNode;
        }

        private static WindowNode collapseWindows(PlanNode source, WindowNode.Specification specification, Collection<WindowNode> windows) {
            WindowNode canonical = windows.iterator().next();
            return new WindowNode(canonical.getId(), source, specification, windows.stream().map(WindowNode::getWindowFunctions).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), canonical.getHashSymbol(), canonical.getPrePartitionedInputs(), canonical.getPreSortedOrderPrefix());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean dependsOn(WindowNode parent, WindowNode child) {
            Set<Symbol> childOutputs = child.getCreatedSymbols();
            Stream arguments = parent.getWindowFunctions().values().stream().map(WindowNode.Function::getFunctionCall).flatMap(functionCall -> functionCall.getArguments().stream()).map(DependencyExtractor::extractUnique).flatMap(Collection::stream);
            if (parent.getPartitionBy().stream().anyMatch(childOutputs::contains)) return true;
            if (parent.getOrderBy().stream().anyMatch(childOutputs::contains)) return true;
            if (!arguments.anyMatch(childOutputs::contains)) return false;
            return true;
        }
    }
}

