/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionSymbolInliner;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.util.AstUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Deprecated
public class MergeProjections
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ProjectNode sourceProject;
            PlanNode source = context.rewrite(node.getSource());
            if (source instanceof ProjectNode && Rewriter.isDeterministic(sourceProject = (ProjectNode)source) && !Rewriter.containsTry(node)) {
                Assignments.Builder projections = Assignments.builder();
                for (Map.Entry<Symbol, Expression> projection : node.getAssignments().entrySet()) {
                    Expression inlined = new ExpressionSymbolInliner(sourceProject.getAssignments().getMap()).rewrite(projection.getValue());
                    projections.put(projection.getKey(), inlined);
                }
                return new ProjectNode(node.getId(), sourceProject.getSource(), projections.build());
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
        }

        private static boolean isDeterministic(ProjectNode node) {
            return node.getAssignments().getExpressions().stream().allMatch(DeterminismEvaluator::isDeterministic);
        }

        private static boolean containsTry(ProjectNode node) {
            return node.getAssignments().getExpressions().stream().flatMap(AstUtils::preOrder).anyMatch(TryExpression.class::isInstance);
        }
    }
}

