/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import java.util.Iterator;
import java.util.Optional;

public class SwapAdjacentWindowsByPartitionsOrder
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session) {
        if (!(node instanceof WindowNode)) {
            return Optional.empty();
        }
        WindowNode parent = (WindowNode)node;
        PlanNode child = lookup.resolve(parent.getSource());
        if (!(child instanceof WindowNode)) {
            return Optional.empty();
        }
        if (SwapAdjacentWindowsByPartitionsOrder.compare(parent, (WindowNode)child) < 0 && !SwapAdjacentWindowsByPartitionsOrder.dependsOn(parent, (WindowNode)child)) {
            return Optional.of(Util.transpose(parent, child));
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean dependsOn(WindowNode parent, WindowNode child) {
        if (parent.getPartitionBy().stream().anyMatch(child.getCreatedSymbols()::contains)) return true;
        if (parent.getOrderBy().stream().anyMatch(child.getCreatedSymbols()::contains)) return true;
        if (!parent.getWindowFunctions().values().stream().map(WindowNode.Function::getFunctionCall).map(DependencyExtractor::extractUnique).flatMap(symbols -> symbols.stream()).anyMatch(child.getCreatedSymbols()::contains)) return false;
        return true;
    }

    private static int compare(WindowNode o1, WindowNode o2) {
        Iterator<Symbol> iterator1 = o1.getPartitionBy().iterator();
        Iterator<Symbol> iterator2 = o2.getPartitionBy().iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Symbol symbol2;
            Symbol symbol1 = iterator1.next();
            int comparison = symbol1.compareTo(symbol2 = iterator2.next());
            if (comparison == 0) continue;
            return comparison;
        }
        if (iterator1.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return o1.getId().toString().compareTo(o2.getId().toString());
    }
}

