/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;

public class RemoveEmptyDelete
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session) {
        if (!(node instanceof TableFinishNode)) {
            return Optional.empty();
        }
        TableFinishNode finish = (TableFinishNode)node;
        PlanNode finishSource = lookup.resolve(finish.getSource());
        if (!(finishSource instanceof ExchangeNode)) {
            return Optional.empty();
        }
        ExchangeNode exchange = (ExchangeNode)finishSource;
        if (exchange.getSources().size() != 1) {
            return Optional.empty();
        }
        PlanNode exchangeSource = lookup.resolve((PlanNode)Iterables.getOnlyElement(exchange.getSources()));
        if (!(exchangeSource instanceof DeleteNode)) {
            return Optional.empty();
        }
        DeleteNode delete = (DeleteNode)exchangeSource;
        PlanNode deleteSource = lookup.resolve(delete.getSource());
        if (!(deleteSource instanceof ValuesNode)) {
            return Optional.empty();
        }
        ValuesNode values = (ValuesNode)deleteSource;
        if (!values.getRows().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("0")))));
    }
}

