/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import java.util.Optional;

public class MergeLimits
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session) {
        if (!(node instanceof LimitNode)) {
            return Optional.empty();
        }
        LimitNode parent = (LimitNode)node;
        PlanNode source = lookup.resolve(parent.getSource());
        if (!(source instanceof LimitNode)) {
            return Optional.empty();
        }
        LimitNode child = (LimitNode)source;
        return Optional.of(new LimitNode(parent.getId(), child.getSource(), Math.min(parent.getCount(), child.getCount()), parent.isPartial()));
    }
}

