/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.ExpressionSymbolInliner;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.util.AstUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InlineProjections
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session) {
        if (!(node instanceof ProjectNode)) {
            return Optional.empty();
        }
        ProjectNode parent = (ProjectNode)node;
        PlanNode source = lookup.resolve(parent.getSource());
        if (!(source instanceof ProjectNode)) {
            return Optional.empty();
        }
        ProjectNode child = (ProjectNode)source;
        Sets.SetView<Symbol> targets = this.extractInliningTargets(parent, child);
        if (targets.isEmpty()) {
            return Optional.empty();
        }
        Assignments assignments = child.getAssignments().filter((Predicate<Symbol>)((Predicate)arg_0 -> targets.contains(arg_0)));
        Map<Symbol, Expression> parentAssignments = parent.getAssignments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.inlineReferences((Expression)entry.getValue(), assignments)));
        Set inputs = child.getAssignments().entrySet().stream().filter(entry -> targets.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(entry -> DependencyExtractor.extractAll(entry).stream()).collect(Collectors.toSet());
        Assignments.Builder childAssignments = Assignments.builder();
        for (Map.Entry<Symbol, Expression> assignment : child.getAssignments().entrySet()) {
            if (targets.contains((Object)assignment.getKey())) continue;
            childAssignments.put(assignment);
        }
        for (Symbol input : inputs) {
            childAssignments.putIdentity(input);
        }
        return Optional.of(new ProjectNode(parent.getId(), new ProjectNode(child.getId(), child.getSource(), childAssignments.build()), Assignments.copyOf(parentAssignments)));
    }

    private Expression inlineReferences(Expression expression, Assignments assignments) {
        Function<Symbol, Expression> mapping = symbol -> {
            Expression result = assignments.get((Symbol)symbol);
            if (result != null) {
                return result;
            }
            return symbol.toSymbolReference();
        };
        return new ExpressionSymbolInliner(mapping).rewrite(expression);
    }

    private Sets.SetView<Symbol> extractInliningTargets(ProjectNode parent, ProjectNode child) {
        Map dependencies = parent.getAssignments().getExpressions().stream().flatMap(expression -> DependencyExtractor.extractAll(expression).stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Set constants = dependencies.keySet().stream().filter(input -> child.getAssignments().get((Symbol)input) instanceof Literal).collect(Collectors.toSet());
        Set tryArguments = parent.getAssignments().getExpressions().stream().flatMap(expression -> this.extractTryArguments((Expression)expression).stream()).collect(Collectors.toSet());
        Set singletons = dependencies.entrySet().stream().filter(entry -> (Long)entry.getValue() == 1L).filter(entry -> !tryArguments.contains(entry.getKey())).filter(entry -> !child.getAssignments().isIdentity((Symbol)entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
        return Sets.union(singletons, constants);
    }

    private Set<Symbol> extractTryArguments(Expression expression) {
        return AstUtils.preOrder((Node)expression).filter(TryExpression.class::isInstance).map(TryExpression.class::cast).flatMap(tryExpression -> DependencyExtractor.extractAll((Expression)tryExpression).stream()).collect(Collectors.toSet());
    }
}

