/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AddIntermediateAggregations
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session) {
        if (!SystemSessionProperties.isEnableIntermediateAggregations(session)) {
            return Optional.empty();
        }
        if (!(node instanceof AggregationNode)) {
            return Optional.empty();
        }
        AggregationNode aggregation = (AggregationNode)node;
        if (aggregation.getStep() != AggregationNode.Step.FINAL || !aggregation.getGroupingKeys().isEmpty()) {
            return Optional.empty();
        }
        Optional<PlanNode> rewrittenSource = this.recurseToPartial(lookup.resolve(aggregation.getSource()), lookup, idAllocator);
        if (!rewrittenSource.isPresent()) {
            return Optional.empty();
        }
        PlanNode source = rewrittenSource.get();
        if (SystemSessionProperties.getTaskConcurrency(session) > 1) {
            source = ExchangeNode.partitionedExchange(idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, source, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), source.getOutputSymbols()));
            source = new AggregationNode(idAllocator.getNextId(), source, AddIntermediateAggregations.inputsAsOutputs(aggregation.getAssignments()), aggregation.getGroupingSets(), AggregationNode.Step.INTERMEDIATE, aggregation.getHashSymbol(), aggregation.getGroupIdSymbol());
            source = ExchangeNode.gatheringExchange(idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, source);
        }
        return Optional.of(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)source)));
    }

    private Optional<PlanNode> recurseToPartial(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator) {
        if (node instanceof AggregationNode && ((AggregationNode)node).getStep() == AggregationNode.Step.PARTIAL) {
            return Optional.of(this.addGatheringIntermediate((AggregationNode)node, idAllocator));
        }
        if (!(node instanceof ExchangeNode) && !(node instanceof ProjectNode)) {
            return Optional.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PlanNode source : node.getSources()) {
            Optional<PlanNode> planNode = this.recurseToPartial(lookup.resolve(source), lookup, idAllocator);
            if (!planNode.isPresent()) {
                return Optional.empty();
            }
            builder.add((Object)planNode.get());
        }
        return Optional.of(node.replaceChildren((List<PlanNode>)builder.build()));
    }

    private PlanNode addGatheringIntermediate(AggregationNode aggregation, PlanNodeIdAllocator idAllocator) {
        Verify.verify((boolean)aggregation.getGroupingKeys().isEmpty(), (String)"Should be an un-grouped aggregation", (Object[])new Object[0]);
        ExchangeNode gatheringExchange = ExchangeNode.gatheringExchange(idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, aggregation);
        return new AggregationNode(idAllocator.getNextId(), gatheringExchange, AddIntermediateAggregations.outputsAsInputs(aggregation.getAssignments()), aggregation.getGroupingSets(), AggregationNode.Step.INTERMEDIATE, aggregation.getHashSymbol(), aggregation.getGroupIdSymbol());
    }

    private static Map<Symbol, AggregationNode.Aggregation> outputsAsInputs(Map<Symbol, AggregationNode.Aggregation> assignments) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : assignments.entrySet()) {
            Symbol output = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            builder.put((Object)output, (Object)new AggregationNode.Aggregation(new FunctionCall(QualifiedName.of((String)aggregation.getSignature().getName()), (List)ImmutableList.of((Object)output.toSymbolReference())), aggregation.getSignature(), Optional.empty()));
        }
        return builder.build();
    }

    private static Map<Symbol, AggregationNode.Aggregation> inputsAsOutputs(Map<Symbol, AggregationNode.Aggregation> assignments) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : assignments.entrySet()) {
            Symbol input = (Symbol)Iterables.getOnlyElement(DependencyExtractor.extractAll((Expression)entry.getValue().getCall()));
            builder.put((Object)input, (Object)entry.getValue());
        }
        return builder.build();
    }
}

