/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class SortExpressionExtractor {
    private SortExpressionExtractor() {
    }

    public static Optional<SortExpression> extractSortExpression(Map<Symbol, Integer> buildLayout, Expression filter) {
        ImmutableSet buildFields = ImmutableSet.copyOf(buildLayout.values());
        if (filter instanceof ComparisonExpression) {
            ComparisonExpression comparison = (ComparisonExpression)filter;
            switch (comparison.getType()) {
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    Optional<Integer> sortChannel = SortExpressionExtractor.asBuildFieldReference((Set<Integer>)buildFields, comparison.getRight());
                    boolean hasBuildReferencesOnOtherSide = SortExpressionExtractor.hasBuildFieldReference((Set<Integer>)buildFields, comparison.getLeft());
                    if (!sortChannel.isPresent()) {
                        sortChannel = SortExpressionExtractor.asBuildFieldReference((Set<Integer>)buildFields, comparison.getLeft());
                        hasBuildReferencesOnOtherSide = SortExpressionExtractor.hasBuildFieldReference((Set<Integer>)buildFields, comparison.getRight());
                    }
                    if (sortChannel.isPresent() && !hasBuildReferencesOnOtherSide) {
                        return Optional.of(new SortExpression(sortChannel.get()));
                    }
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static Optional<Integer> asBuildFieldReference(Set<Integer> buildLayout, Expression expression) {
        FieldReference field;
        if (expression instanceof FieldReference && buildLayout.contains((field = (FieldReference)expression).getFieldIndex())) {
            return Optional.of(field.getFieldIndex());
        }
        return Optional.empty();
    }

    private static boolean hasBuildFieldReference(Set<Integer> buildLayout, Expression expression) {
        return (Boolean)new BuildFieldReferenceFinder(buildLayout).process((Node)expression);
    }

    public static class SortExpression {
        private final int channel;

        public SortExpression(int channel) {
            this.channel = channel;
        }

        public int getChannel() {
            return this.channel;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SortExpression other = (SortExpression)obj;
            return Objects.equals(this.channel, other.channel);
        }

        public int hashCode() {
            return Objects.hash(this.channel);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("channel", this.channel).toString();
        }
    }

    private static class BuildFieldReferenceFinder
    extends AstVisitor<Boolean, Void> {
        private final Set<Integer> buildLayout;

        public BuildFieldReferenceFinder(Set<Integer> buildLayout) {
            this.buildLayout = ImmutableSet.copyOf((Collection)Objects.requireNonNull(buildLayout, "buildLayout is null"));
        }

        protected Boolean visitNode(Node node, Void context) {
            for (Node child : node.getChildren()) {
                if (!((Boolean)this.process(child, context)).booleanValue()) continue;
                return true;
            }
            return false;
        }

        protected Boolean visitFieldReference(FieldReference fieldReference, Void context) {
            return this.buildLayout.contains(fieldReference.getFieldIndex());
        }
    }
}

