/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.Symbol;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PartitioningScheme {
    private final Partitioning partitioning;
    private final List<Symbol> outputLayout;
    private final Optional<Symbol> hashColumn;
    private final boolean replicateNulls;
    private final Optional<int[]> bucketToPartition;

    public PartitioningScheme(Partitioning partitioning, List<Symbol> outputLayout) {
        this(partitioning, outputLayout, Optional.empty(), false, Optional.empty());
    }

    public PartitioningScheme(Partitioning partitioning, List<Symbol> outputLayout, Optional<Symbol> hashColumn) {
        this(partitioning, outputLayout, hashColumn, false, Optional.empty());
    }

    @JsonCreator
    public PartitioningScheme(@JsonProperty(value="partitioning") Partitioning partitioning, @JsonProperty(value="outputLayout") List<Symbol> outputLayout, @JsonProperty(value="hashColumn") Optional<Symbol> hashColumn, @JsonProperty(value="replicateNulls") boolean replicateNulls, @JsonProperty(value="bucketToPartition") Optional<int[]> bucketToPartition) {
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.outputLayout = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputLayout, "outputLayout is null"));
        Set<Symbol> columns = partitioning.getColumns();
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(outputLayout).containsAll(columns), (String)"Output layout (%s) don't include all partition columns (%s)", outputLayout, columns);
        this.hashColumn = Objects.requireNonNull(hashColumn, "hashColumn is null");
        hashColumn.ifPresent(column -> Preconditions.checkArgument((boolean)outputLayout.contains(column), (String)"Output layout (%s) don't include hash column (%s)", (Object)outputLayout, (Object)column));
        Preconditions.checkArgument((!replicateNulls || columns.size() <= 1 ? 1 : 0) != 0, (Object)"Must have at most one partitioning column when nullPartition is REPLICATE.");
        this.replicateNulls = replicateNulls;
        this.bucketToPartition = Objects.requireNonNull(bucketToPartition, "bucketToPartition is null");
    }

    @JsonProperty
    public Partitioning getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public List<Symbol> getOutputLayout() {
        return this.outputLayout;
    }

    @JsonProperty
    public Optional<Symbol> getHashColumn() {
        return this.hashColumn;
    }

    @JsonProperty
    public boolean isReplicateNulls() {
        return this.replicateNulls;
    }

    @JsonProperty
    public Optional<int[]> getBucketToPartition() {
        return this.bucketToPartition;
    }

    public PartitioningScheme withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new PartitioningScheme(this.partitioning, this.outputLayout, this.hashColumn, this.replicateNulls, bucketToPartition);
    }

    public PartitioningScheme translateOutputLayout(List<Symbol> newOutputLayout) {
        Objects.requireNonNull(newOutputLayout, "newOutputLayout is null");
        Preconditions.checkArgument((newOutputLayout.size() == this.outputLayout.size() ? 1 : 0) != 0);
        Partitioning newPartitioning = this.partitioning.translate(symbol -> (Symbol)newOutputLayout.get(this.outputLayout.indexOf(symbol)));
        Optional<Symbol> newHashSymbol = this.hashColumn.map(this.outputLayout::indexOf).map(newOutputLayout::get);
        return new PartitioningScheme(newPartitioning, newOutputLayout, newHashSymbol, this.replicateNulls, this.bucketToPartition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitioningScheme that = (PartitioningScheme)o;
        return Objects.equals(this.partitioning, that.partitioning) && Objects.equals(this.outputLayout, that.outputLayout) && this.replicateNulls == that.replicateNulls && Objects.equals(this.bucketToPartition, that.bucketToPartition);
    }

    public int hashCode() {
        return Objects.hash(this.partitioning, this.outputLayout, this.replicateNulls, this.bucketToPartition);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitioning", (Object)this.partitioning).add("outputLayout", this.outputLayout).add("hashChannel", this.hashColumn).add("replicateNulls", this.replicateNulls).add("bucketToPartition", this.bucketToPartition).toString();
    }
}

