/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LambdaCaptureDesugaringRewriter {
    private final Map<Symbol, Type> symbolTypes;
    private final SymbolAllocator symbolAllocator;

    public LambdaCaptureDesugaringRewriter(Map<Symbol, Type> symbolTypes, SymbolAllocator symbolAllocator) {
        this.symbolTypes = Objects.requireNonNull(symbolTypes, "symbolTypes is null");
        this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
    }

    public Expression rewrite(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression, (Object)new Context());
    }

    private static Expression replaceSymbols(Expression expression, final ImmutableMap<Symbol, Symbol> symbolMapping) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Symbol mapTo = (Symbol)symbolMapping.get((Object)new Symbol(node.getName()));
                if (mapTo == null) {
                    return node;
                }
                return mapTo.toSymbolReference();
            }
        }, (Expression)expression);
    }

    private static class Context {
        LinkedHashSet<Symbol> referencedSymbols;

        public Context() {
            this(new LinkedHashSet<Symbol>());
        }

        private Context(LinkedHashSet<Symbol> referencedSymbols) {
            this.referencedSymbols = referencedSymbols;
        }

        public LinkedHashSet<Symbol> getReferencedSymbols() {
            return this.referencedSymbols;
        }

        public Context withReferencedSymbols(LinkedHashSet<Symbol> symbols) {
            return new Context(symbols);
        }
    }

    public class Visitor
    extends ExpressionRewriter<Context> {
        public Expression rewriteLambdaExpression(LambdaExpression node, Context context, ExpressionTreeRewriter<Context> treeRewriter) {
            LinkedHashSet<Symbol> referencedSymbols = new LinkedHashSet<Symbol>();
            Expression rewrittenBody = treeRewriter.rewrite(node.getBody(), (Object)context.withReferencedSymbols(referencedSymbols));
            List lambdaArguments = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Symbol::new).collect(ImmutableList.toImmutableList());
            referencedSymbols.removeAll(lambdaArguments);
            LinkedHashSet<Symbol> captureSymbols = referencedSymbols;
            ImmutableMap.Builder captureSymbolToExtraSymbol = ImmutableMap.builder();
            ImmutableList.Builder newLambdaArguments = ImmutableList.builder();
            for (Symbol captureSymbol : captureSymbols) {
                Symbol extraSymbol = LambdaCaptureDesugaringRewriter.this.symbolAllocator.newSymbol(captureSymbol.getName(), (Type)LambdaCaptureDesugaringRewriter.this.symbolTypes.get(captureSymbol));
                captureSymbolToExtraSymbol.put((Object)captureSymbol, (Object)extraSymbol);
                newLambdaArguments.add((Object)new LambdaArgumentDeclaration(extraSymbol.getName()));
            }
            newLambdaArguments.addAll((Iterable)node.getArguments());
            LambdaExpression rewrittenExpression = new LambdaExpression((List)newLambdaArguments.build(), LambdaCaptureDesugaringRewriter.replaceSymbols(rewrittenBody, (ImmutableMap<Symbol, Symbol>)captureSymbolToExtraSymbol.build()));
            for (Symbol captureSymbol : captureSymbols) {
                rewrittenExpression = new BindExpression((Expression)new SymbolReference(captureSymbol.getName()), (Expression)rewrittenExpression);
            }
            context.getReferencedSymbols().addAll(captureSymbols);
            return rewrittenExpression;
        }

        public Expression rewriteSymbolReference(SymbolReference node, Context context, ExpressionTreeRewriter<Context> treeRewriter) {
            context.getReferencedSymbols().add(new Symbol(node.getName()));
            return null;
        }
    }
}

