/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ExpressionSymbolInliner {
    private final Function<Symbol, Expression> mapping;

    @Deprecated
    public ExpressionSymbolInliner(Map<Symbol, ? extends Expression> mappings) {
        this.mapping = mappings::get;
    }

    public ExpressionSymbolInliner(Function<Symbol, Expression> mapping) {
        this.mapping = mapping;
    }

    public Expression rewrite(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression);
    }

    private class Visitor
    extends ExpressionRewriter<Void> {
        private final Set<String> excludedNames = new HashSet<String>();

        private Visitor() {
        }

        public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (this.excludedNames.contains(node.getName())) {
                return node;
            }
            Expression expression = (Expression)ExpressionSymbolInliner.this.mapping.apply(Symbol.from((Expression)node));
            Preconditions.checkState((expression != null ? 1 : 0) != 0, (String)"Cannot resolve symbol %s", (Object)node.getName());
            return expression;
        }

        public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            for (LambdaArgumentDeclaration argument : node.getArguments()) {
                String argumentName = argument.getName();
                Preconditions.checkArgument((!this.excludedNames.contains(argumentName) ? 1 : 0) != 0);
                this.excludedNames.add(argumentName);
            }
            Expression result = treeRewriter.defaultRewrite((Expression)node, (Object)context);
            for (LambdaArgumentDeclaration argument : node.getArguments()) {
                this.excludedNames.remove(argument.getName());
            }
            return result;
        }
    }
}

